/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.processor;

import com.google.auto.service.AutoService;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"dev.the_fireplace.annotateddi.api.di.Implementation"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_16)
@AutoService(value={Processor.class})
public final class ImplementationProcessor
extends AbstractProcessor {
    private static final String VERSION = "2.0.0+1.17.1";
    private final Gson gson = new Gson();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            List<Element> implementations = this.getValidAnnotatedElements(annotatedElements);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Valid @Implementation count: " + implementations.size());
            if (implementations.isEmpty()) continue;
            this.writeJsonToFile(this.convertImplementationsToJson(implementations));
        }
        return false;
    }

    private List<Element> getValidAnnotatedElements(Set<? extends Element> annotatedElements) {
        Map<Boolean, List<Element>> annotatedClasses = annotatedElements.stream().collect(Collectors.partitioningBy(this::isValidAnnotatedElement));
        List<Element> validAnnotatedClasses = annotatedClasses.get(true);
        List<Element> invalidAnnotatedClasses = annotatedClasses.get(false);
        invalidAnnotatedClasses.forEach(this::logImplementationError);
        return validAnnotatedClasses;
    }

    private JsonObject convertImplementationsToJson(List<Element> implementations) {
        JsonArray outputImplementationsJson = new JsonArray();
        for (Element implementationElement : implementations) {
            Implementation implAnnotation = implementationElement.getAnnotation(Implementation.class);
            List<String> interfaceNames = this.getInterfaceNames((TypeElement)implementationElement, implAnnotation);
            JsonObject implementationJson = this.createImplementationJsonObject(implementationElement, interfaceNames, implAnnotation.name());
            outputImplementationsJson.add((JsonElement)implementationJson);
        }
        JsonObject outputJson = new JsonObject();
        outputJson.addProperty("version", VERSION);
        outputJson.add("implementations", (JsonElement)outputImplementationsJson);
        return outputJson;
    }

    private void writeJsonToFile(JsonObject outputJson) {
        try {
            FileObject builderFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "annotated-di.json", new Element[0]);
            try (JsonWriter writer = this.gson.newJsonWriter((Writer)new BufferedWriter(builderFile.openWriter()));){
                this.gson.toJson((JsonElement)outputJson, writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> getInterfaceNames(TypeElement implementationElement, Implementation implAnnotation) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (this.usesImplicitInterface(implAnnotation)) {
            interfaces.add(this.getImplicitInterface(implementationElement));
        } else {
            interfaces.addAll(this.getExplicitInterfaces(implAnnotation));
        }
        return interfaces;
    }

    private boolean isValidAnnotatedElement(Element element) {
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        Implementation implAnnotation = element.getAnnotation(Implementation.class);
        if (implAnnotation == null) {
            return false;
        }
        if (this.usesImplicitInterface(implAnnotation)) {
            return ((TypeElement)element).getInterfaces().size() == 1;
        }
        return true;
    }

    private void logImplementationError(Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Implementation must be applied to a class which implements a single Interface, or provide the name(s) of the Interface(s) to implement.", element);
    }

    private JsonObject createImplementationJsonObject(Element implementationElement, List<String> interfaceNames, String namedImplementationName) {
        JsonObject output = new JsonObject();
        output.addProperty("class", implementationElement.asType().toString());
        if (!namedImplementationName.isBlank()) {
            output.addProperty("namedImplementation", namedImplementationName);
        }
        JsonArray interfacesJsonArray = new JsonArray();
        for (String interfaceName : interfaceNames) {
            interfacesJsonArray.add(interfaceName);
        }
        output.add("interfaces", (JsonElement)interfacesJsonArray);
        return output;
    }

    private String getImplicitInterface(TypeElement implementationElement) {
        return implementationElement.getInterfaces().get(0).toString();
    }

    private List<String> getExplicitInterfaces(Implementation implAnnotation) {
        return Arrays.stream(implAnnotation.value()).toList();
    }

    private boolean usesImplicitInterface(Implementation implAnnotation) {
        return Arrays.equals(implAnnotation.value(), new String[]{""});
    }
}

