/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.MessageQueue;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_2165;
import net.minecraft.class_2561;

@Singleton
@ThreadSafe
@Implementation
public final class MessageQueueImpl
implements MessageQueue {
    private final Map<class_2165, TargetMessageQueue> messageQueues = new ConcurrentHashMap<class_2165, TargetMessageQueue>();
    private final ExecutionManager executionManager;

    @Inject
    public MessageQueueImpl(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    private TargetMessageQueue getOrCreateQueue(class_2165 messageTarget) {
        return this.messageQueues.computeIfAbsent(messageTarget, x$0 -> new TargetMessageQueue((class_2165)x$0));
    }

    @Override
    public void queueMessages(class_2165 messageTarget, class_2561 ... messages) {
        this.getOrCreateQueue(messageTarget).queueMessages(messages);
    }

    @ThreadSafe
    private class TargetMessageQueue {
        private final Queue<class_2561> messages = new ArrayDeque<class_2561>();
        private final class_2165 messageTarget;
        private final AtomicBoolean sendingMessages = new AtomicBoolean(false);

        private TargetMessageQueue(class_2165 messageTarget) {
            this.messageTarget = messageTarget;
        }

        private synchronized void queueMessages(class_2561 ... messages) {
            this.messages.addAll(Arrays.asList(messages));
            if (!this.sendingMessages.get()) {
                MessageQueueImpl.this.executionManager.runKillable(this::sendMessages);
            }
        }

        private synchronized void sendMessages() {
            this.sendingMessages.set(true);
            while (!this.messages.isEmpty()) {
                this.messageTarget.method_9203(this.messages.remove());
            }
            this.sendingMessages.set(false);
        }
    }
}

