/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat.translation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.inject.Injector;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.io.injectables.DirectoryResolver;
import dev.the_fireplace.lib.domain.io.LoaderSpecificDirectories;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_3518;

final class LanguageMap {
    private static final Pattern NUMERIC_VARIABLE_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private final Map<String, String> languageList = new ConcurrentHashMap<String, String>();
    private final LoaderSpecificDirectories loaderSpecificDirectories;
    private final String modId;

    LanguageMap(String modid, String locale) {
        Injector injector = FireplaceLibConstants.getInjector();
        DirectoryResolver directoryResolver = (DirectoryResolver)injector.getInstance(DirectoryResolver.class);
        this.loaderSpecificDirectories = (LoaderSpecificDirectories)injector.getInstance(LoaderSpecificDirectories.class);
        this.modId = modid;
        String langDir = directoryResolver.getLangDirectory(modid);
        try {
            JsonElement jsonelement = this.getLangJsonElement(locale, langDir);
            JsonObject jsonobject = class_3518.method_15295((JsonElement)jsonelement, (String)"strings");
            for (Map.Entry entry : jsonobject.entrySet()) {
                String s = NUMERIC_VARIABLE_PATTERN.matcher(class_3518.method_15287((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
                this.languageList.put((String)entry.getKey(), s);
            }
        }
        catch (JsonParseException e) {
            FireplaceLibConstants.getLogger().error(langDir + locale + ".json is improperly formatted.", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JsonElement getLangJsonElement(String locale, String langDir) throws IOException {
        String langJsonPath = langDir + locale + ".json";
        InputStream inputstream = this.getInputStream(langJsonPath);
        if (inputstream == null) {
            FireplaceLibConstants.getLogger().error("Invalid locale: {}, defaulting to en_us.", (Object)locale);
            String defaultLangDir = langDir + "en_us.json";
            inputstream = this.getInputStream(defaultLangDir);
        }
        if (inputstream == null) {
            FireplaceLibConstants.getLogger().error("Unable to read language file in directory {}!", (Object)langDir);
            return new JsonObject();
        }
        JsonElement jsonelement = (JsonElement)new Gson().fromJson((Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8), JsonElement.class);
        inputstream.close();
        return jsonelement;
    }

    @Nullable
    private InputStream getInputStream(String langFileDirectory) {
        Optional<Path> resource;
        InputStream inputstream = LanguageMap.class.getResourceAsStream(langFileDirectory);
        if (inputstream == null && (resource = this.loaderSpecificDirectories.getResource(this.modId, langFileDirectory)).isPresent()) {
            try {
                inputstream = Files.newInputStream(resource.get(), new OpenOption[0]);
            }
            catch (IOException exception) {
                FireplaceLibConstants.getLogger().warn(String.format("Could not create input stream for resource %s", resource.get()), (Throwable)exception);
            }
        }
        return inputstream;
    }

    String translateKeyFormat(String key, Object ... format) {
        String translation = this.tryTranslateKey(key);
        try {
            return String.format(translation, format);
        }
        catch (IllegalFormatException e) {
            return "Format error: " + translation;
        }
    }

    private String tryTranslateKey(String key) {
        String translation = this.languageList.get(key);
        return translation == null ? key : translation;
    }

    boolean isKeyTranslated(String key) {
        return this.languageList.containsKey(key);
    }
}

