/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat.translation;

import dev.the_fireplace.lib.chat.translation.LanguageMap;
import dev.the_fireplace.lib.chat.translation.proxy.LocaleProxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ModLanguageMaps {
    private static final Map<String, LanguageMap> PRIMARY_LANGUAGE_MAPS = new ConcurrentHashMap<String, LanguageMap>();
    private static final Map<String, LanguageMap> FALLBACK_LANGUAGE_MAPS = new ConcurrentHashMap<String, LanguageMap>();

    static LanguageMap getPrimaryMap(String modid) {
        return PRIMARY_LANGUAGE_MAPS.computeIfAbsent(modid, unused -> new LanguageMap(modid, LocaleProxy.getInstance().getLocale()));
    }

    static LanguageMap getFallbackMap(String modid) {
        return FALLBACK_LANGUAGE_MAPS.computeIfAbsent(modid, unused -> new LanguageMap(modid, "en_us"));
    }

    public static void reloadLanguage() {
        PRIMARY_LANGUAGE_MAPS.clear();
    }
}

