/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat.translation;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.lib.chat.translation.I18n;
import dev.the_fireplace.lib.domain.translation.LocalizedClients;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

@Singleton
@ThreadSafe
@Implementation
public final class TranslatorManager
implements TranslatorFactory {
    private final ConcurrentMap<String, Translator> modTranslators = new ConcurrentHashMap<String, Translator>();
    private final EmptyUUID emptyUUID;
    private final LocalizedClients localizedClients;
    private final I18n i18n;

    @Inject
    public TranslatorManager(EmptyUUID emptyUUID, LocalizedClients localizedClients, I18n i18n) {
        this.emptyUUID = emptyUUID;
        this.localizedClients = localizedClients;
        this.i18n = i18n;
    }

    @Override
    public void addTranslator(String modid) {
        this.modTranslators.put(modid, new TranslatorImpl(modid));
    }

    @Override
    public Translator getTranslator(String modid) {
        return this.modTranslators.computeIfAbsent(modid, x$0 -> new TranslatorImpl((String)x$0));
    }

    @Override
    public Collection<String> availableTranslators() {
        return this.modTranslators.keySet();
    }

    @ThreadSafe
    private class TranslatorImpl
    implements Translator {
        private final String modid;

        private TranslatorImpl(String modid) {
            this.modid = modid;
        }

        @Override
        public class_2561 getTextForTarget(class_2168 target, String translationKey, Object ... args) {
            return this.getTextForTarget(this.getTargetId(target), translationKey, args);
        }

        @Override
        public class_2561 getTextForTarget(class_2165 target, String translationKey, Object ... args) {
            return this.getTextForTarget(this.getTargetId(target), translationKey, args);
        }

        @Override
        public class_2561 getTextForTarget(UUID target, String translationKey, Object ... args) {
            if (!TranslatorManager.this.localizedClients.isLocalized(this.modid, target)) {
                return this.getTranslatedText(translationKey, args);
            }
            return new class_2588(translationKey, args);
        }

        @Override
        public class_2585 getTranslatedText(String translationKey, Object ... translationArguments) {
            Object[] readableTranslationArguments = this.convertArgumentsToStrings(translationArguments);
            return new class_2585(TranslatorManager.this.i18n.translateToLocalFormatted(this.modid, translationKey, readableTranslationArguments));
        }

        private Object[] convertArgumentsToStrings(Object[] arguments) {
            Object[] convertedArgs = (Object[])arguments.clone();
            for (int argumentIndex = 0; argumentIndex < arguments.length; ++argumentIndex) {
                if (!(arguments[argumentIndex] instanceof class_2561)) continue;
                convertedArgs[argumentIndex] = ((class_2561)arguments[argumentIndex]).getString();
            }
            return convertedArgs;
        }

        @Override
        public String getTranslatedString(String translationKey, Object ... translationArguments) {
            return this.getTranslatedText(translationKey, translationArguments).getString();
        }

        @Override
        public String getTranslationKeyForTarget(class_2165 target, String translationKey) {
            return this.getTranslationKeyForTarget(this.getTargetId(target), translationKey);
        }

        @Override
        public String getTranslationKeyForTarget(UUID target, String translationKey) {
            if (!TranslatorManager.this.localizedClients.isLocalized(this.modid, target)) {
                return TranslatorManager.this.i18n.translateToLocalFormatted(this.modid, translationKey, new Object[0]);
            }
            return translationKey;
        }

        protected UUID getTargetId(class_2168 commandSource) {
            return commandSource.method_9228() instanceof class_3222 ? commandSource.method_9228().method_5667() : TranslatorManager.this.emptyUUID.get();
        }

        protected UUID getTargetId(class_2165 commandOutput) {
            return commandOutput instanceof class_3222 ? ((class_1297)commandOutput).method_5667() : TranslatorManager.this.emptyUUID.get();
        }
    }
}

