/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.command.helpers;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.the_fireplace.lib.api.command.interfaces.OfflineSupportedPlayerArgumentType;
import dev.the_fireplace.lib.api.command.interfaces.PossiblyOfflinePlayer;
import dev.the_fireplace.lib.command.helpers.SelectedPlayerArgument;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.server.MinecraftServer;

public final class OfflinePlayerArgumentType
implements OfflineSupportedPlayerArgumentType {
    private static final Collection<String> EXAMPLES = Arrays.asList("PlayerName", "@p", "dd12be42-52a9-4a91-a8a1-11c01849e498");

    public PlayerSelector parse(StringReader reader) throws CommandSyntaxException {
        int startCursor = reader.getCursor();
        class_2303 entitySelectorReader = new class_2303(reader);
        class_2300 entitySelector = entitySelectorReader.method_9882();
        if (entitySelector.method_9815() > 1) {
            reader.setCursor(0);
            throw class_2186.field_9864.createWithContext((ImmutableStringReader)reader);
        }
        if (entitySelector.method_9819() && !entitySelector.method_9820()) {
            reader.setCursor(0);
            throw class_2186.field_9861.createWithContext((ImmutableStringReader)reader);
        }
        int endCursor = reader.getCursor();
        reader.setCursor(startCursor);
        StringBuilder lastArgumentStringBuilder = new StringBuilder();
        while (reader.getCursor() < endCursor) {
            lastArgumentStringBuilder.append(reader.read());
        }
        return new PlayerSelector(entitySelector, lastArgumentStringBuilder.toString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2172) {
            StringReader reader = new StringReader(builder.getInput());
            reader.setCursor(builder.getStart());
            class_2303 entitySelectorReader = new class_2303(reader);
            try {
                entitySelectorReader.method_9882();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorReader.method_9908(builder, suggestionsBuilder -> {
                Collection iterable = ((class_2172)context.getSource()).method_9262();
                class_2172.method_9265((Iterable)iterable, (SuggestionsBuilder)suggestionsBuilder);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static class PlayerSelector
    implements dev.the_fireplace.lib.api.command.interfaces.PlayerSelector {
        private final class_2300 entitySelector;
        private final String offlinePlayerName;

        private PlayerSelector(class_2300 entitySelector, String offlinePlayerName) {
            this.entitySelector = entitySelector;
            this.offlinePlayerName = offlinePlayerName;
        }

        @Override
        public PossiblyOfflinePlayer get(class_2168 source) throws CommandSyntaxException {
            try {
                List list = this.entitySelector.method_9813(source);
                if (list.size() != 1) {
                    throw class_2186.field_9856.create();
                }
                class_3222 player = (class_3222)list.get(0);
                return new SelectedPlayerArgument(player.method_7334(), player);
            }
            catch (CommandSyntaxException e) {
                MinecraftServer server = source.method_9211();
                class_3312.method_14510((boolean)true);
                GameProfile offlinePlayerProfileByName = server.method_3793().method_14515(this.offlinePlayerName);
                if (offlinePlayerProfileByName != null) {
                    return new SelectedPlayerArgument(offlinePlayerProfileByName);
                }
                try {
                    GameProfile offlinePlayerProfileById = server.method_3793().method_14512(UUID.fromString(this.offlinePlayerName));
                    if (offlinePlayerProfileById != null) {
                        return new SelectedPlayerArgument(offlinePlayerProfileById);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                throw class_2186.field_9856.create();
            }
        }
    }

    public static class Serializer
    implements class_2314<OfflinePlayerArgumentType> {
        public void serializeToNetwork(OfflinePlayerArgumentType entityArgumentType, class_2540 packetByteBuf) {
            byte b = 0;
            b = (byte)(b | 1);
            b = (byte)(b | 2);
            packetByteBuf.writeByte((int)b);
        }

        public OfflinePlayerArgumentType deserializeFromNetwork(class_2540 packetByteBuf) {
            return new OfflinePlayerArgumentType();
        }

        public void serializeToJson(OfflinePlayerArgumentType entityArgumentType, JsonObject jsonObject) {
            jsonObject.addProperty("amount", "single");
            jsonObject.addProperty("type", "players");
        }
    }
}

