/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth;

import dev.the_fireplace.lib.config.cloth.ClothOptionDependency;
import dev.the_fireplace.lib.domain.config.OptionTypeConverter;
import dev.the_fireplace.lib.mixin.clothconfig.AbstractConfigEntryAccessor;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ClothConfigDependencyHandler {
    public static final Set<AbstractConfigEntry<?>> DISABLED_ENTRIES = new HashSet();
    private final Set<ClothOptionDependency<?, ?>> configEntries = new HashSet();

    public <S, T> void addOption(final AbstractConfigListEntry<T> option, final OptionTypeConverter<S, T> typeConverter) {
        this.configEntries.add(new ClothOptionDependency<S, T>(){

            @Override
            public AbstractConfigListEntry<T> getEntry() {
                return option;
            }

            @Override
            public OptionTypeConverter<S, T> getConverter() {
                return typeConverter;
            }

            @Override
            public S getConvertedValue() {
                return typeConverter.convertFromClothType(option.getValue());
            }
        });
    }

    public void addDependency(AbstractConfigListEntry<?> parent, AbstractConfigListEntry<?> child, Predicate<Object> shouldShowChildBasedOnParentValue) {
        Supplier<Optional<String>> configEntryErrorSupplier = ((AbstractConfigEntryAccessor)parent).getErrorSupplier();
        Supplier<Optional<String>> dependencyCheckingErrorSupplier = this.addDependencyCheckToErrorSupplier(parent, child, shouldShowChildBasedOnParentValue, configEntryErrorSupplier);
        parent.setErrorSupplier(dependencyCheckingErrorSupplier);
    }

    @Nonnull
    private Supplier<Optional<String>> addDependencyCheckToErrorSupplier(AbstractConfigListEntry<?> parentConfigEntry, AbstractConfigListEntry<?> childConfigEntry, Predicate<Object> shouldShowChildBasedOnParentValue, @Nullable Supplier<Optional<String>> errorSupplier) {
        return () -> {
            Object parentEntryGuiValue = this.getClothOptionDependency(parentConfigEntry).getConvertedValue();
            if (!DISABLED_ENTRIES.contains(parentConfigEntry) && shouldShowChildBasedOnParentValue.test(parentEntryGuiValue)) {
                this.showConfigEntry((AbstractConfigEntry<?>)childConfigEntry);
            } else {
                this.hideConfigEntry((AbstractConfigEntry<?>)childConfigEntry);
            }
            return errorSupplier != null ? (Optional)errorSupplier.get() : Optional.empty();
        };
    }

    private <T> ClothOptionDependency<?, T> getClothOptionDependency(AbstractConfigListEntry<T> entry) {
        for (ClothOptionDependency<?, ?> clothOptionDependency : this.configEntries) {
            if (!clothOptionDependency.getEntry().equals(entry)) continue;
            return clothOptionDependency;
        }
        throw new IllegalStateException("Cloth Option Dependency not found!");
    }

    private void hideConfigEntry(AbstractConfigEntry<?> dependentEntry) {
        DISABLED_ENTRIES.add(dependentEntry);
    }

    private void showConfigEntry(AbstractConfigEntry<?> dependentEntry) {
        DISABLED_ENTRIES.remove(dependentEntry);
    }
}

