/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth.optionbuilder;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.interfaces.DropdownOptionBuilder;
import dev.the_fireplace.lib.config.cloth.optionbuilder.ClothGenericOption;
import dev.the_fireplace.lib.domain.config.OptionTypeConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class ClothDropdownOption<S, T>
extends ClothGenericOption<S, T>
implements DropdownOptionBuilder<S> {
    public ClothDropdownOption(Translator translator, FieldBuilder<S, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Iterable<S> entries, Consumer<S> saveFunction) {
        super(translator, fieldBuilder, optionTranslationBase, defaultValue, saveFunction);
        this.setSelections(entries);
        this.setSuggestionMode(false);
    }

    public ClothDropdownOption(Translator translator, FieldBuilder<T, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Iterable<S> entries, Consumer<S> saveFunction, OptionTypeConverter<S, T> typeConverter) {
        super(translator, fieldBuilder, optionTranslationBase, defaultValue, saveFunction, typeConverter);
        this.setSelections(entries);
        this.setSuggestionMode(false);
    }

    @Override
    public DropdownOptionBuilder<S> enableSuggestionMode() {
        this.setSuggestionMode(true);
        return this;
    }

    private void setSuggestionMode(boolean suggestionMode) {
        try {
            Method setMaximum = this.findSingleParameterMethod("setSuggestionMode", Boolean.class);
            setMaximum.invoke((Object)this.fieldBuilder, suggestionMode);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set suggestion mode for field builder of type " + this.fieldBuilder.getClass(), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
    }

    private void setSelections(Iterable<S> entries) {
        ArrayList selections = new ArrayList();
        entries.forEach(entry -> selections.add(this.typeConverter.convertToClothType(entry)));
        try {
            Method setErrorSupplier = this.findSingleParameterMethod("setSelections", Iterable.class);
            setErrorSupplier.invoke((Object)this.fieldBuilder, selections);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set selections for field builder of type " + this.fieldBuilder.getClass(), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
    }
}

