/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth.optionbuilder;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.interfaces.NumericOptionBuilder;
import dev.the_fireplace.lib.config.cloth.optionbuilder.ClothGenericOption;
import dev.the_fireplace.lib.domain.config.OptionTypeConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class ClothNumericOption<S, T>
extends ClothGenericOption<S, T>
implements NumericOptionBuilder<S> {
    public ClothNumericOption(Translator translator, FieldBuilder<S, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Consumer<S> saveFunction) {
        super(translator, fieldBuilder, optionTranslationBase, defaultValue, saveFunction);
    }

    public ClothNumericOption(Translator translator, FieldBuilder<T, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Consumer<S> saveFunction, OptionTypeConverter<S, T> typeConverter) {
        super(translator, fieldBuilder, optionTranslationBase, defaultValue, saveFunction, typeConverter);
    }

    @Override
    public NumericOptionBuilder<S> setMinimum(S minimum) {
        Object clothMinimum = this.typeConverter.convertToClothType(minimum);
        try {
            Method setMinimum = this.findSingleParameterMethod("setMin", clothMinimum.getClass());
            setMinimum.invoke((Object)this.fieldBuilder, clothMinimum);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set minimum for field builder of type " + this.fieldBuilder.getClass() + " with target type " + clothMinimum.getClass(), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
        return this;
    }

    @Override
    public NumericOptionBuilder<S> setMaximum(S maximum) {
        Object clothMaximum = this.typeConverter.convertToClothType(maximum);
        try {
            Method setMaximum = this.findSingleParameterMethod("setMax", clothMaximum.getClass());
            setMaximum.invoke((Object)this.fieldBuilder, clothMaximum);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set maximum for field builder of type " + this.fieldBuilder.getClass() + " with target type " + clothMaximum.getClass(), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
        return this;
    }
}

