/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.entrypoints;

import com.google.inject.Injector;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.client.entrypoints.ConfigGuiEntrypoint;
import dev.the_fireplace.lib.api.client.interfaces.ConfigGuiRegistry;
import dev.the_fireplace.lib.api.client.interfaces.ConfigScreenFactory;
import dev.the_fireplace.lib.config.FLConfigScreenFactory;
import dev.the_fireplace.lib.domain.config.ConfigScreenBuilderFactoryProxy;
import io.github.prospector.modmenu.api.ModMenuApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ModMenu
implements ModMenuApi {
    private final FLConfigScreenFactory flConfigScreenFactory = (FLConfigScreenFactory)FireplaceLibConstants.getInjector().getInstance(FLConfigScreenFactory.class);
    private Map<String, io.github.prospector.modmenu.api.ConfigScreenFactory<?>> configScreenFactories = null;

    public Map<String, io.github.prospector.modmenu.api.ConfigScreenFactory<?>> getProvidedConfigScreenFactories() {
        if (this.configScreenFactories == null) {
            this.loadConfigScreenFactories();
        }
        return this.configScreenFactories;
    }

    private void loadConfigScreenFactories() {
        HashMap configScreenFactories = new HashMap();
        ModMenuConfigGuiRegistry configGuiRegistry = new ModMenuConfigGuiRegistry(configScreenFactories);
        Injector injector = FireplaceLibConstants.getInjector();
        ConfigScreenBuilderFactoryProxy builderFactoryProxy = (ConfigScreenBuilderFactoryProxy)injector.getInstance(ConfigScreenBuilderFactoryProxy.class);
        if (builderFactoryProxy.hasActiveFactory()) {
            FabricLoader.getInstance().getEntrypointContainers("fireplacelib", ConfigGuiEntrypoint.class).forEach(configGuiEntrypoint -> {
                configGuiRegistry.activeModId = configGuiEntrypoint.getProvider().getMetadata().getId();
                ((ConfigGuiEntrypoint)configGuiEntrypoint.getEntrypoint()).registerConfigGuis(configGuiRegistry);
            });
        }
        this.configScreenFactories = configGuiRegistry.configScreenFactories;
    }

    public io.github.prospector.modmenu.api.ConfigScreenFactory<?> getModConfigScreenFactory() {
        Injector injector = FireplaceLibConstants.getInjector();
        ConfigScreenBuilderFactoryProxy builderFactoryProxy = (ConfigScreenBuilderFactoryProxy)injector.getInstance(ConfigScreenBuilderFactoryProxy.class);
        if (builderFactoryProxy.hasActiveFactory()) {
            return this.flConfigScreenFactory::getConfigScreen;
        }
        return super.getModConfigScreenFactory();
    }

    private static class ModMenuConfigGuiRegistry
    implements ConfigGuiRegistry {
        private final Map<String, io.github.prospector.modmenu.api.ConfigScreenFactory<?>> configScreenFactories;
        private String activeModId;

        public ModMenuConfigGuiRegistry(Map<String, io.github.prospector.modmenu.api.ConfigScreenFactory<?>> configScreenFactories) {
            this.configScreenFactories = configScreenFactories;
        }

        @Override
        public <S extends class_437> void register(String modid, ConfigScreenFactory<S> createConfigGui) {
            if (!Objects.equals(this.activeModId, modid)) {
                FireplaceLibConstants.getLogger().warn("Registering config screen for mod {} while active mod is {}.", (Object)modid, (Object)this.activeModId);
            }
            this.configScreenFactories.put(modid, createConfigGui::create);
        }
    }
}

