/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.init;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.lazyio.injectables.SaveTimer;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import dev.the_fireplace.lib.command.FLCommands;
import dev.the_fireplace.lib.command.helpers.ArgumentTypeFactoryImpl;
import dev.the_fireplace.lib.domain.init.LoaderSpecificInitialization;
import dev.the_fireplace.lib.network.NetworkEvents;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.server.MinecraftServer;

@Singleton
public final class FireplaceLibInitializer {
    private boolean initialized = false;
    private final TranslatorFactory translatorFactory;
    private final ExecutionManager executionManager;
    private final FLCommands fireplaceLibCommands;
    private final SaveTimer saveTimer;
    private final ArgumentTypeFactoryImpl argumentTypeFactory;
    private final LoaderSpecificInitialization loaderSpecificInitialization;
    private final NetworkEvents networkEvents;

    @Inject
    public FireplaceLibInitializer(TranslatorFactory translatorFactory, ExecutionManager executionManager, FLCommands fireplaceLibCommands, SaveTimer saveTimer, ArgumentTypeFactoryImpl argumentTypeFactory, LoaderSpecificInitialization loaderSpecificInitialization, NetworkEvents networkEvents) {
        this.translatorFactory = translatorFactory;
        this.executionManager = executionManager;
        this.fireplaceLibCommands = fireplaceLibCommands;
        this.saveTimer = saveTimer;
        this.argumentTypeFactory = argumentTypeFactory;
        this.loaderSpecificInitialization = loaderSpecificInitialization;
        this.networkEvents = networkEvents;
    }

    public void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.translatorFactory.addTranslator("fireplacelib");
            this.argumentTypeFactory.registerArgumentTypes();
            this.networkEvents.init();
            this.loaderSpecificInitialization.registerServerStartingCallback(this::onServerStarting);
            this.loaderSpecificInitialization.registerServerStoppingCallback(this::onServerStopping);
            this.loaderSpecificInitialization.registerServerStoppedCallback(s -> FireplaceLibConstants.setMinecraftServer(null));
        }
    }

    private void onServerStarting(MinecraftServer server) {
        FireplaceLibConstants.setMinecraftServer(server);
        this.executionManager.startExecutors();
        this.saveTimer.resetTimer();
        this.fireplaceLibCommands.register(server);
    }

    private void onServerStopping(MinecraftServer server) {
        this.saveTimer.prepareForServerShutdown();
        try {
            this.executionManager.waitForCompletion();
        }
        catch (InterruptedException e) {
            FireplaceLibConstants.getLogger().error("Interrupted while trying to wait for execution manager to complete.", (Throwable)e);
        }
    }
}

