/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.inventory;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.inventory.injectables.InventorySearcher;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

@Implementation
public final class InventorySearcherImpl
implements InventorySearcher {
    @Override
    public boolean hasSlotMatching(class_1263 inventory, Predicate<class_1799> matcher) {
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            if (!matcher.test(inventory.method_5438(slot))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Integer> findFirstMatchingSlot(class_1263 inventory, Predicate<class_1799> matcher) {
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            if (!matcher.test(inventory.method_5438(slot))) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    @Override
    public List<Integer> findMatchingSlots(class_1263 inventory, Predicate<class_1799> matcher) {
        IntArrayList slotList = new IntArrayList();
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            if (!matcher.test(inventory.method_5438(slot))) continue;
            slotList.add(slot);
        }
        return slotList;
    }

    @Override
    public Multimap<Integer, Integer> getMatchingSlotsByPriority(class_1263 inventory, Predicate<class_1799> matcher, ToIntFunction<class_1799> priorityMapper) {
        IntArrayList slotList = new IntArrayList();
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            if (!matcher.test(inventory.method_5438(slot))) continue;
            slotList.add(slot);
        }
        Multimap<Integer, Integer> slotPriorityMap = LinkedHashMultimap.create();
        IntListIterator intListIterator = slotList.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            slotPriorityMap.put((Object)priorityMapper.applyAsInt(inventory.method_5438(slot)), (Object)slot);
        }
        slotPriorityMap = this.sortByKey(slotPriorityMap);
        return slotPriorityMap;
    }

    @Override
    public Multimap<Integer, Integer> getSlotsByPriority(class_1263 inventory, ToIntFunction<class_1799> priorityMapper) {
        Multimap<Integer, Integer> slotPriorityMap = LinkedHashMultimap.create();
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            slotPriorityMap.put((Object)priorityMapper.applyAsInt(inventory.method_5438(slot)), (Object)slot);
        }
        slotPriorityMap = this.sortByKey(slotPriorityMap);
        return slotPriorityMap;
    }

    private Multimap<Integer, Integer> sortByKey(Multimap<Integer, Integer> slotPriorityMap) {
        slotPriorityMap = (Multimap)slotPriorityMap.entries().stream().sorted((i1, i2) -> Integer.compare((Integer)i2.getKey(), (Integer)i1.getKey())).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, LinkedHashMultimap::create));
        return slotPriorityMap;
    }
}

