/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.io.injectables.JsonFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
@Implementation
public final class ExternalResourceToJson
implements JsonFileReader {
    @Override
    @Nullable
    public JsonObject readJsonFile(File file) {
        block8: {
            JsonObject jsonObject;
            FileReader fileReader2 = new FileReader(file);
            try {
                jsonObject = this.readJsonFromReader(fileReader2);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileReader2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileReader2) {
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            fileReader2.close();
            return jsonObject;
        }
        return null;
    }

    @Override
    @Nullable
    public JsonObject readJsonFromStream(InputStream stream) {
        JsonObject jsonObject;
        InputStreamReader inputStreamReader = new InputStreamReader(stream);
        try {
            jsonObject = this.readJsonFromReader(inputStreamReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        inputStreamReader.close();
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject readJsonFromReader(Reader reader) throws IOException {
        JsonParser jsonParser = new JsonParser();
        try (BufferedReader br = new BufferedReader(reader, Short.MAX_VALUE);){
            JsonElement jsonElement = jsonParser.parse((Reader)br);
            if (!(jsonElement instanceof JsonObject)) return null;
            JsonObject jsonObject = (JsonObject)jsonElement;
            return jsonObject;
        }
        catch (JsonParseException e) {
            FireplaceLibConstants.getLogger().warn("Unable to parse json file!", (Throwable)e);
        }
        return null;
    }
}

