/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.client.injectables.FileDialogFactory;
import dev.the_fireplace.lib.api.io.injectables.FilePathStorage;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@Singleton
@Implementation(environment="CLIENT")
public final class FileDialogFactoryImpl
implements FileDialogFactory {
    private final FilePathStorage filePathStorage;

    @Inject
    public FileDialogFactoryImpl(FilePathStorage filePathStorage) {
        this.filePathStorage = filePathStorage;
    }

    @Override
    @Nullable
    public File showOpenFileDialog(String titleTranslationKey, boolean rememberPath, @Nullable String[] allowedFileTypePatterns, @Nullable String allowedFileTypesDescription) {
        return this.showOpenFileDialog((class_2561)new class_2588(titleTranslationKey, new Object[0]), rememberPath, allowedFileTypePatterns, allowedFileTypesDescription);
    }

    @Override
    @Nullable
    public File showOpenFileDialog(class_2561 title, boolean rememberPath, @Nullable String[] allowedFileTypePatterns, @Nullable String allowedFileTypesDescription) {
        PointerBuffer pointerBuffer = this.convertToPointerBuffer(allowedFileTypePatterns);
        String displayedTitle = title.getString();
        String rememberedPath = this.getPathFromMemory(rememberPath, displayedTitle);
        String filePath = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)displayedTitle, (CharSequence)rememberedPath, (PointerBuffer)pointerBuffer, (CharSequence)allowedFileTypesDescription, (boolean)false);
        this.storePathToMemory(rememberPath, displayedTitle, filePath);
        return filePath != null ? new File(filePath) : null;
    }

    @Override
    @Nullable
    public File[] showOpenMultiFileDialog(String titleTranslationKey, boolean rememberPath, @Nullable String[] allowedFileTypePatterns, @Nullable String allowedFileTypesDescription) {
        return this.showOpenMultiFileDialog((class_2561)new class_2588(titleTranslationKey, new Object[0]), rememberPath, allowedFileTypePatterns, allowedFileTypesDescription);
    }

    @Override
    @Nullable
    public File[] showOpenMultiFileDialog(class_2561 title, boolean rememberPath, @Nullable String[] allowedFileTypePatterns, @Nullable String allowedFileTypesDescription) {
        String rememberedPath;
        PointerBuffer pointerBuffer = this.convertToPointerBuffer(allowedFileTypePatterns);
        String displayedTitle = title.getString();
        String filePath = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)displayedTitle, (CharSequence)(rememberedPath = this.getPathFromMemory(rememberPath, displayedTitle)), (PointerBuffer)pointerBuffer, (CharSequence)allowedFileTypesDescription, (boolean)false);
        if (filePath == null) {
            return null;
        }
        this.storePathToMemory(rememberPath, displayedTitle, filePath);
        String[] filePaths = filePath.split("\\|");
        ArrayList<File> files = new ArrayList<File>(filePaths.length);
        for (String path : filePaths) {
            files.add(new File(path));
        }
        return files.toArray(new File[0]);
    }

    @Override
    @Nullable
    public File showSaveFileDialog(String titleTranslationKey, boolean rememberPath, @Nullable String[] allowedFileTypePatterns, @Nullable String allowedFileTypesDescription) {
        return this.showSaveFileDialog((class_2561)new class_2588(titleTranslationKey, new Object[0]), rememberPath, allowedFileTypePatterns, allowedFileTypesDescription);
    }

    @Override
    @Nullable
    public File showSaveFileDialog(class_2561 title, boolean rememberPath, @Nullable String[] allowedFileTypePatterns, @Nullable String allowedFileTypesDescription) {
        PointerBuffer pointerBuffer = this.convertToPointerBuffer(allowedFileTypePatterns);
        String displayedTitle = title.getString();
        String rememberedPath = this.getPathFromMemory(rememberPath, displayedTitle);
        String filePath = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)displayedTitle, (CharSequence)rememberedPath, (PointerBuffer)pointerBuffer, (CharSequence)allowedFileTypesDescription);
        this.storePathToMemory(rememberPath, displayedTitle, filePath);
        return filePath != null ? new File(filePath) : null;
    }

    @Nullable
    private String getPathFromMemory(boolean rememberPath, String pathKey) {
        String rememberedPath;
        String string = rememberedPath = rememberPath ? this.filePathStorage.getFilePath(pathKey) : null;
        if (rememberedPath != null && rememberedPath.isEmpty()) {
            rememberedPath = null;
        }
        return rememberedPath;
    }

    private void storePathToMemory(boolean rememberPath, String pathKey, @Nullable String filePath) {
        if (filePath != null && rememberPath) {
            this.filePathStorage.storeFilePath(pathKey, filePath);
        }
    }

    @Nullable
    private PointerBuffer convertToPointerBuffer(@Nullable String[] strings) {
        PointerBuffer fileTypePatternsPointerBuffer = null;
        if (strings != null && strings.length > 0) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                fileTypePatternsPointerBuffer = stack.mallocPointer(strings.length);
                for (String pattern : strings) {
                    fileTypePatternsPointerBuffer.put(stack.UTF8((CharSequence)pattern));
                }
                fileTypePatternsPointerBuffer.flip();
            }
        }
        return fileTypePatternsPointerBuffer;
    }
}

