/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io.access;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.io.injectables.SaveBasedStorageWriter;
import dev.the_fireplace.lib.api.io.interfaces.SaveBasedSerializable;
import dev.the_fireplace.lib.api.lazyio.interfaces.Defaultable;
import dev.the_fireplace.lib.io.access.JsonStoragePath;
import dev.the_fireplace.lib.io.access.JsonStorageWriteBuffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.Logger;

@Singleton
@Implementation
public final class SaveBasedJsonStorageWriter
implements SaveBasedStorageWriter {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Logger logger = FireplaceLibConstants.getLogger();
    private final JsonStoragePath jsonStoragePath;

    @Inject
    public SaveBasedJsonStorageWriter(JsonStoragePath jsonStoragePath) {
        this.jsonStoragePath = jsonStoragePath;
    }

    @Override
    public boolean write(SaveBasedSerializable writable) {
        boolean bl;
        Path filePath = this.jsonStoragePath.resolveSaveBasedJsonFilePath(writable);
        File folder = filePath.getParent().toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            this.logger.error("Unable to make folder for {}!", (Object)filePath.toString());
            return false;
        }
        File outputFile = filePath.toFile();
        if (writable instanceof Defaultable && ((Defaultable)((Object)writable)).isDefault()) {
            if (outputFile.exists() && !outputFile.delete()) {
                this.logger.error("Unable to delete {}!", (Object)filePath.toString());
            }
            return true;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile), Short.MAX_VALUE);
        try {
            JsonStorageWriteBuffer writeBuffer = new JsonStorageWriteBuffer();
            writable.writeTo(writeBuffer);
            this.gson.toJson((JsonElement)writeBuffer.getObj(), (Appendable)bw);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.logger.error("Failed to write file!", (Throwable)e);
                return false;
            }
        }
        bw.close();
        return bl;
    }

    @Override
    public boolean delete(SaveBasedSerializable writable) {
        Path filePath = this.jsonStoragePath.resolveSaveBasedJsonFilePath(writable);
        File folder = filePath.getParent().toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            return false;
        }
        File outputFile = filePath.toFile();
        if (!outputFile.exists()) {
            return false;
        }
        return outputFile.delete();
    }
}

