/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io.access;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class SimpleJsonBuffer
implements SimpleBuffer {
    private final JsonObject jsonObject;

    public SimpleJsonBuffer(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public UUID readUUID(String key) {
        String uuidString = this.jsonObject.get(key).getAsString();
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new ClassCastException("String could not be converted to UUID!");
        }
    }

    @Override
    public String readString(String key) {
        return this.jsonObject.get(key).getAsString();
    }

    @Override
    public long readLong(String key) {
        return this.jsonObject.get(key).getAsLong();
    }

    @Override
    public int readInt(String key) {
        return this.jsonObject.get(key).getAsInt();
    }

    @Override
    public short readShort(String key) {
        return this.jsonObject.get(key).getAsShort();
    }

    @Override
    public byte readByte(String key) {
        return this.jsonObject.get(key).getAsByte();
    }

    @Override
    public double readDouble(String key) {
        return this.jsonObject.get(key).getAsDouble();
    }

    @Override
    public float readFloat(String key) {
        return this.jsonObject.get(key).getAsFloat();
    }

    @Override
    public boolean readBool(String key) {
        return this.jsonObject.get(key).getAsBoolean();
    }

    @Override
    public List<Boolean> readBoolList(String key) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        JsonArray array = this.jsonObject.getAsJsonArray(key);
        for (JsonElement element : array) {
            list.add(element.getAsBoolean());
        }
        return list;
    }

    @Override
    public List<Number> readNumberList(String key) {
        ArrayList<Number> list = new ArrayList<Number>();
        JsonArray array = this.jsonObject.getAsJsonArray(key);
        for (JsonElement element : array) {
            list.add(element.getAsNumber());
        }
        return list;
    }

    @Override
    public List<String> readStringList(String key) {
        ArrayList<String> list = new ArrayList<String>();
        JsonArray array = this.jsonObject.getAsJsonArray(key);
        for (JsonElement element : array) {
            list.add(element.getAsString());
        }
        return list;
    }

    @Override
    public Map<String, String> readStringToStringMap(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        JsonArray array = this.jsonObject.getAsJsonArray(key);
        for (JsonElement element : array) {
            JsonObject object = element.getAsJsonObject();
            map.put(object.get("key").getAsString(), object.get("value").getAsString());
        }
        return map;
    }

    @Override
    public boolean hasKey(String key) {
        return this.jsonObject.has(key);
    }
}

