/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.lazyio.hierarchicalconfig;

import com.google.common.collect.Sets;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.lazyio.injectables.ReloadableManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfigManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Reloadable;
import dev.the_fireplace.lib.io.access.JsonStoragePath;
import dev.the_fireplace.lib.lazyio.hierarchicalconfig.HierarchicalConfigLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class HierarchicalConfigManagerImpl<T extends HierarchicalConfig>
implements HierarchicalConfigManager<T> {
    private final HierarchicalConfigLoader configLoader;
    private final JsonStoragePath jsonStoragePath;
    private final ReloadableManager reloadableManager;
    private final String domain;
    private final T defaultConfig;
    private final Iterable<String> allowedModuleIds;
    private final Map<String, T> modules;

    public HierarchicalConfigManagerImpl(String domain, T defaultConfig, Iterable<String> allowedModuleIds, HierarchicalConfigLoader configLoader, JsonStoragePath jsonStoragePath, ReloadableManager reloadableManager) {
        this.domain = domain;
        this.defaultConfig = defaultConfig;
        this.allowedModuleIds = allowedModuleIds;
        this.modules = new ConcurrentHashMap<String, T>();
        this.configLoader = configLoader;
        this.jsonStoragePath = jsonStoragePath;
        this.reloadableManager = reloadableManager;
        this.loadExistingHierarchy();
        this.registerHierarchyReloadable();
    }

    private void loadExistingHierarchy() {
        for (String id : this.allowedModuleIds) {
            Path filePath = this.jsonStoragePath.resolveConfigBasedJsonFilePath(this.domain, id);
            if (!filePath.toFile().exists() || this.modules.containsKey(id)) continue;
            HierarchicalConfig module = this.defaultConfig.clone();
            try {
                this.addCustom(id, module);
            }
            catch (ClassCastException exception) {
                FireplaceLibConstants.getLogger().error("Cloned hierarchical config was not of the expected type!", (Throwable)exception);
            }
        }
    }

    private void registerHierarchyReloadable() {
        this.reloadableManager.register(new Reloadable(){

            @Override
            public void reload() {
                HierarchicalConfigManagerImpl.this.loadExistingHierarchy();
            }

            @Override
            public String getReloadGroup() {
                return HierarchicalConfigManagerImpl.this.domain;
            }
        });
    }

    @Override
    public Iterable<String> getAllowedModuleIds() {
        return this.allowedModuleIds;
    }

    @Override
    public T get(String moduleId) {
        return (T)((HierarchicalConfig)this.modules.getOrDefault(moduleId, this.defaultConfig));
    }

    @Override
    public Collection<String> getCustoms() {
        return Sets.newHashSet(this.modules.keySet());
    }

    @Override
    public boolean isCustom(String moduleId) {
        return this.modules.containsKey(moduleId);
    }

    @Override
    public void addCustom(String moduleId, T module) {
        this.modules.put(moduleId, module);
        this.configLoader.initialize(module, this.domain, moduleId);
    }

    @Override
    public boolean deleteCustom(String moduleId) {
        HierarchicalConfig module = (HierarchicalConfig)this.modules.remove(moduleId);
        if (module == null) {
            return false;
        }
        return this.configLoader.delete(this.domain, moduleId);
    }

    @Override
    public void saveAllCustoms() {
        for (Map.Entry<String, T> moduleEntry : this.modules.entrySet()) {
            this.configLoader.save((HierarchicalConfig)moduleEntry.getValue(), this.domain, moduleEntry.getKey());
        }
    }

    @Override
    public void saveCustom(String id) {
        HierarchicalConfig module = (HierarchicalConfig)this.modules.get(id);
        if (module == null) {
            FireplaceLibConstants.getLogger().error("Custom config does not exist, and cannot be saved: " + id);
            return;
        }
        this.configLoader.save(module, this.domain, id);
    }
}

