/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.multithreading;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import dev.the_fireplace.lib.domain.config.ConfigValues;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.Logger;

@Singleton
@Implementation
public final class ConcurrentExecutionManager
implements ExecutionManager {
    private final ConfigValues configValues;
    private final Logger logger = FireplaceLibConstants.getLogger();
    private ExecutorService essentialExecutorService;
    private ExecutorService nonessentialExecutorService;

    @Inject
    public ConcurrentExecutionManager(ConfigValues configValues) {
        this.configValues = configValues;
        this.essentialExecutorService = Executors.newFixedThreadPool(configValues.getEssentialThreadPoolSize());
        this.nonessentialExecutorService = Executors.newFixedThreadPool(configValues.getNonEssentialThreadPoolSize());
    }

    @Override
    public void run(Runnable runnable) {
        if (!this.essentialExecutorService.isShutdown()) {
            try {
                this.essentialExecutorService.execute(runnable);
            }
            catch (RejectedExecutionException exception) {
                this.logger.debug("Running essential runnable immediately because the executor rejected it.", (Throwable)exception);
                runnable.run();
            }
        } else {
            this.logger.trace("Running essential runnable immediately because the executor has already stopped.", (Throwable)new Exception("Stack trace"));
            runnable.run();
        }
    }

    @Override
    public void runKillable(Runnable runnable) {
        if (!this.nonessentialExecutorService.isShutdown()) {
            try {
                this.nonessentialExecutorService.execute(runnable);
            }
            catch (RejectedExecutionException exception) {
                this.logger.debug("Failed to add nonessential runnable because the executor rejected it.", (Throwable)exception);
            }
        } else {
            this.logger.trace("Failed to add nonessential runnable because the executor has already stopped.", (Throwable)new Exception("Stack trace"));
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        boolean timedOut;
        this.essentialExecutorService.shutdown();
        this.nonessentialExecutorService.shutdownNow();
        boolean bl = timedOut = !this.essentialExecutorService.awaitTermination(1L, TimeUnit.DAYS);
        if (timedOut) {
            FireplaceLibConstants.getLogger().error("Timed out awaiting essential threads to terminate.");
        }
    }

    @Override
    public void startExecutors() {
        if (this.essentialExecutorService.isShutdown() || this.nonessentialExecutorService.isShutdown()) {
            try {
                this.waitForCompletion();
            }
            catch (InterruptedException e) {
                FireplaceLibConstants.getLogger().error("Interrupted while waiting to complete essential execution!", (Throwable)e);
            }
            this.essentialExecutorService = Executors.newFixedThreadPool(this.configValues.getEssentialThreadPoolSize());
            this.nonessentialExecutorService = Executors.newFixedThreadPool(this.configValues.getNonEssentialThreadPoolSize());
        }
    }
}

