/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.teleport;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.teleport.injectables.SafePosition;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3922;
import net.minecraft.class_4048;

@Implementation
public final class SafePositionImpl
implements SafePosition {
    private final ImmutableList<class_2382> xzOffsets = ImmutableList.of((Object)new class_2382(0, 0, -1), (Object)new class_2382(-1, 0, 0), (Object)new class_2382(0, 0, 1), (Object)new class_2382(1, 0, 0), (Object)new class_2382(-1, 0, -1), (Object)new class_2382(1, 0, -1), (Object)new class_2382(-1, 0, 1), (Object)new class_2382(1, 0, 1));
    private final ImmutableList<class_2382> teleportAreaOffsets = new ImmutableList.Builder().addAll(this.xzOffsets).addAll(this.xzOffsets.stream().map(class_2382::method_23228).iterator()).addAll(this.xzOffsets.stream().map(v3i -> v3i.method_23227(-1)).iterator()).add((Object)new class_2382(0, 1, 0)).build();
    private final Set<class_2248> blocksNothingCanSpawnInside = Sets.newHashSet((Object[])new class_2248[]{class_2246.field_10606, class_2246.field_16999, class_2246.field_10029});

    @Override
    public Optional<class_243> findBy(class_1299<?> entityType, class_1941 world, class_2338 blockPos) {
        return this.findRespawnPosition(entityType, world, blockPos);
    }

    @Override
    public boolean canSpawnInside(class_1299<?> entityType, class_2680 state) {
        boolean blockDealsFireDamage;
        boolean bl = blockDealsFireDamage = state.method_11614().equals(class_2246.field_10036) || state.method_11614().equals(class_2246.field_10092) || this.isLitCampfire(state) || state.method_11614().equals(class_2246.field_10164);
        if (!entityType.method_19946() && blockDealsFireDamage) {
            return false;
        }
        return !this.blocksNothingCanSpawnInside.contains(state.method_11614());
    }

    private boolean isLitCampfire(class_2680 state) {
        return state.method_11614() == class_2246.field_17350 && (Boolean)state.method_11654((class_2769)class_3922.field_17352) != false;
    }

    private Optional<class_243> findRespawnPosition(class_1299<?> entity, class_1941 world, class_2338 pos) {
        Optional<class_243> optional = this.findSafeNearbyPosition(entity, world, pos, true);
        return optional.isPresent() ? optional : this.findSafeNearbyPosition(entity, world, pos, false);
    }

    private Optional<class_243> findSafeNearbyPosition(class_1299<?> entityType, class_1941 world, class_2338 blockPos, boolean protectAgainstHazardousSpawn) {
        class_243 safePosition;
        class_2338.class_2339 mutableTargetPos = new class_2338.class_2339();
        UnmodifiableIterator offsetIterator = this.teleportAreaOffsets.iterator();
        do {
            if (!offsetIterator.hasNext()) {
                return Optional.empty();
            }
            class_2382 checkOffset = (class_2382)offsetIterator.next();
            mutableTargetPos.method_10101((class_2382)blockPos).method_10100(checkOffset.method_10263(), checkOffset.method_10264(), checkOffset.method_10260());
        } while ((safePosition = this.checkPositionForSafety(entityType, world, (class_2338)mutableTargetPos, protectAgainstHazardousSpawn)) == null);
        return Optional.of(safePosition);
    }

    @Nullable
    private class_243 checkPositionForSafety(class_1299<?> entityType, class_1941 world, class_2338 blockPos, boolean protectAgainstHazardousSpawn) {
        if (protectAgainstHazardousSpawn && !this.canSpawnInside(entityType, world.method_8320(blockPos))) {
            return null;
        }
        double dismountHeight = this.getDismountHeight(this.getCollisionShape((class_1922)world, blockPos), () -> this.getCollisionShape((class_1922)world, blockPos.method_10074()));
        if (!this.canDismountInBlock(dismountHeight)) {
            return null;
        }
        if (protectAgainstHazardousSpawn && dismountHeight <= 0.0 && !this.canSpawnInside(entityType, world.method_8320(blockPos.method_10074()))) {
            return null;
        }
        class_243 vec3d = this.getCenteredSpawnVector((class_2382)blockPos, dismountHeight);
        return world.method_20812(null, this.getCollisionBoxForPosition(entityType.method_18386(), vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215())).allMatch(class_265::method_1110) ? vec3d : null;
    }

    private double getDismountHeight(class_265 blockCollisionShape, Supplier<class_265> belowBlockCollisionShapeGetter) {
        if (!blockCollisionShape.method_1110()) {
            return blockCollisionShape.method_1105(class_2350.class_2351.field_11052);
        }
        double dismountHeight = belowBlockCollisionShapeGetter.get().method_1105(class_2350.class_2351.field_11052);
        return dismountHeight >= 1.0 ? dismountHeight - 1.0 : Double.NEGATIVE_INFINITY;
    }

    private class_265 getCollisionShape(class_1922 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return !(blockState.method_11614() instanceof class_2399) && !(blockState.method_11614() instanceof class_2541) && (!(blockState.method_11614() instanceof class_2533) || (Boolean)blockState.method_11654((class_2769)class_2533.field_11631) == false) ? blockState.method_11628(world, pos) : class_259.method_1073();
    }

    private boolean canDismountInBlock(double height) {
        return !Double.isInfinite(height) && height < 1.0;
    }

    private class_243 getCenteredSpawnVector(class_2382 vec, double deltaY) {
        return new class_243((double)vec.method_10263() + 0.5, (double)vec.method_10264() + deltaY, (double)vec.method_10260() + 0.5);
    }

    public class_238 getCollisionBoxForPosition(class_4048 entityDimensions, double x, double y, double z) {
        float widthOffset = entityDimensions.field_18067 / 2.0f;
        float heightOffset = entityDimensions.field_18068;
        return new class_238(x - (double)widthOffset, y, z - (double)widthOffset, x + (double)widthOffset, y + (double)heightOffset, z + (double)widthOffset);
    }
}

