/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat;

import com.google.common.collect.Lists;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.MessageQueue;
import dev.the_fireplace.lib.api.chat.injectables.TextPaginator;
import dev.the_fireplace.lib.api.chat.injectables.TextStyles;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

@Singleton
@ThreadSafe
@Implementation
public final class TextPaginatorImpl
implements TextPaginator {
    private static final int RESULTS_PER_PAGE = 7;
    private final MessageQueue messageQueue;
    private final Translator translator;
    private final TextStyles textStyles;

    @Inject
    public TextPaginatorImpl(MessageQueue messageQueue, TranslatorFactory translatorFactory, TextStyles textStyles) {
        this.messageQueue = messageQueue;
        this.translator = translatorFactory.getTranslator("fireplacelib");
        this.textStyles = textStyles;
    }

    @Override
    public void sendPaginatedChat(class_2168 targetCommandSource, String switchPageCommand, List<? extends class_2561> allItems, int pageIndex) {
        class_1297 messageTarget = targetCommandSource.method_9228() != null ? targetCommandSource.method_9228() : targetCommandSource.method_9211();
        this.messageQueue.queueMessages((class_2165)messageTarget, this.getPaginatedContent((class_2165)messageTarget, allItems, pageIndex, switchPageCommand));
    }

    private static int getPageCount(int itemCount) {
        int pageCount = itemCount / 7;
        if (itemCount % 7 > 0) {
            ++pageCount;
        }
        return pageCount;
    }

    private class_2561[] getPaginatedContent(class_2165 target, List<? extends class_2561> allContent, int page, String switchPageCommand) {
        int totalPageCount = TextPaginatorImpl.getPageCount(allContent.size());
        class_2561 header = this.getPaginationHeader(target, page, totalPageCount);
        List<? extends class_2561> content = TextPaginatorImpl.getPageContents(allContent, page);
        class_2561 footer = this.getPaginationFooter(target, switchPageCommand, page, totalPageCount);
        ArrayList outputTexts = Lists.newArrayList();
        outputTexts.add(header);
        outputTexts.addAll(content);
        outputTexts.add(footer);
        return outputTexts.toArray(new class_2561[0]);
    }

    private class_2561 getPaginationHeader(class_2165 target, int currentPage, int totalPageCount) {
        class_5250 pageNumber = this.translator.getTextForTarget(target, "fireplacelib.chat.page.num", currentPage, totalPageCount);
        return class_2561.method_43470((String)"-----------------").method_10862(this.textStyles.green()).method_10852((class_2561)pageNumber).method_27693("-------------------").method_10862(this.textStyles.green());
    }

    private static List<? extends class_2561> getPageContents(List<? extends class_2561> allContents, int page) {
        return (List)Lists.partition(allContents, (int)7).get(page - 1);
    }

    private class_2561 getPaginationFooter(class_2165 target, String switchPageCommand, int currentPage, int totalPageCount) {
        class_2561 nextButton = this.getNextButton(target, switchPageCommand, currentPage, totalPageCount);
        class_2561 prevButton = this.getPreviousButton(target, switchPageCommand, currentPage);
        return class_2561.method_43470((String)"---------------").method_10862(this.textStyles.green()).method_10852(prevButton).method_27693("---").method_10862(this.textStyles.green()).method_10852(nextButton).method_27693("-------------").method_10862(this.textStyles.green());
    }

    private class_2561 getNextButton(class_2165 target, String switchPageCommand, int currentPage, int totalPageCount) {
        class_2558 viewNextPage = new class_2558(class_2558.class_2559.field_11750, String.format(switchPageCommand, currentPage + 1));
        return currentPage < totalPageCount ? this.translator.getTextForTarget(target, "fireplacelib.chat.page.next", new Object[0]).method_10862(class_2583.field_24360.method_10958(viewNextPage)) : class_2561.method_43470((String)"-----");
    }

    private class_2561 getPreviousButton(class_2165 target, String switchPageCommand, int currentPage) {
        class_2558 viewPreviousPage = new class_2558(class_2558.class_2559.field_11750, String.format(switchPageCommand, currentPage - 1));
        return currentPage > 1 ? this.translator.getTextForTarget(target, "fireplacelib.chat.page.prev", new Object[0]).method_10862(class_2583.field_24360.method_10958(viewPreviousPage)) : class_2561.method_43470((String)"------");
    }
}

