/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat.translation;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.lib.chat.translation.I18n;
import dev.the_fireplace.lib.domain.translation.LocalizedClients;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Singleton
@ThreadSafe
@Implementation
public final class TranslatorManager
implements TranslatorFactory {
    private final ConcurrentMap<String, Translator> modTranslators = new ConcurrentHashMap<String, Translator>();
    private final EmptyUUID emptyUUID;
    private final LocalizedClients localizedClients;
    private final I18n i18n;

    @Inject
    public TranslatorManager(EmptyUUID emptyUUID, LocalizedClients localizedClients, I18n i18n) {
        this.emptyUUID = emptyUUID;
        this.localizedClients = localizedClients;
        this.i18n = i18n;
    }

    @Override
    public void addTranslator(String modId) {
        this.modTranslators.put(modId, new TranslatorImpl(modId));
    }

    @Override
    public Translator getTranslator(String modId) {
        return this.modTranslators.computeIfAbsent(modId, x$0 -> new TranslatorImpl((String)x$0));
    }

    @Override
    public Collection<String> availableTranslators() {
        return this.modTranslators.keySet();
    }

    @ThreadSafe
    private class TranslatorImpl
    implements Translator {
        private final String modId;

        private TranslatorImpl(String modId) {
            this.modId = modId;
        }

        @Override
        public class_5250 getTextForTarget(class_2168 target, String translationKey, Object ... arguments) {
            return this.getTextForTarget(this.getTargetPlayerId(target), translationKey, arguments);
        }

        @Override
        public class_5250 getTextForTarget(class_2165 target, String translationKey, Object ... arguments) {
            return this.getTextForTarget(this.getTargetPlayerId(target), translationKey, arguments);
        }

        @Override
        public class_5250 getTextForTarget(UUID targetPlayerId, String translationKey, Object ... arguments) {
            if (TranslatorManager.this.localizedClients.isLocalized(this.modId, targetPlayerId)) {
                return class_2561.method_43469((String)translationKey, (Object[])arguments);
            }
            return this.getTranslatedText(translationKey, arguments);
        }

        @Override
        public class_5250 getTranslatedText(String translationKey, Object ... arguments) {
            Object[] readableTranslationArguments = this.convertArgumentsToStrings(arguments);
            return class_2561.method_43470((String)TranslatorManager.this.i18n.translateToLocalFormatted(this.modId, translationKey, readableTranslationArguments));
        }

        private Object[] convertArgumentsToStrings(Object[] arguments) {
            Object[] convertedArgs = (Object[])arguments.clone();
            for (int argumentIndex = 0; argumentIndex < arguments.length; ++argumentIndex) {
                Object object = arguments[argumentIndex];
                if (!(object instanceof class_5348)) continue;
                class_5348 visitable = (class_5348)object;
                convertedArgs[argumentIndex] = visitable.getString();
            }
            return convertedArgs;
        }

        @Override
        public String getTranslatedString(String translationKey, Object ... arguments) {
            return this.getTranslatedText(translationKey, arguments).getString();
        }

        @Override
        public String getTranslationKeyForTarget(class_2165 target, String translationKey) {
            return this.getTranslationKeyForTarget(this.getTargetPlayerId(target), translationKey);
        }

        @Override
        public String getTranslationKeyForTarget(UUID targetPlayerId, String translationKey) {
            if (TranslatorManager.this.localizedClients.isLocalized(this.modId, targetPlayerId)) {
                return translationKey;
            }
            return TranslatorManager.this.i18n.translateToLocalFormatted(this.modId, translationKey, new Object[0]);
        }

        protected UUID getTargetPlayerId(class_2168 commandSource) {
            return commandSource.method_9228() instanceof class_3222 ? commandSource.method_9228().method_5667() : TranslatorManager.this.emptyUUID.get();
        }

        protected UUID getTargetPlayerId(class_2165 commandOutput) {
            if (commandOutput instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)commandOutput;
                return serverPlayerEntity.method_5667();
            }
            return TranslatorManager.this.emptyUUID.get();
        }
    }
}

