/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.interfaces.ConfigScreenBuilder;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonBuilder;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonScreenFactory;
import dev.the_fireplace.lib.api.client.interfaces.DecimalSliderOptionBuilder;
import dev.the_fireplace.lib.api.client.interfaces.DropdownOptionBuilder;
import dev.the_fireplace.lib.api.client.interfaces.NumericOptionBuilder;
import dev.the_fireplace.lib.api.client.interfaces.OptionBuilder;
import dev.the_fireplace.lib.config.cloth.ClothConfigDependencyHandler;
import dev.the_fireplace.lib.config.cloth.FloatingPointClothConverter;
import dev.the_fireplace.lib.config.cloth.custombutton.CustomButtonFieldBuilder;
import dev.the_fireplace.lib.config.cloth.custombutton.CustomButtonOption;
import dev.the_fireplace.lib.config.cloth.optionbuilder.ClothGenericOption;
import dev.the_fireplace.lib.config.cloth.optionbuilder.SubCategoryTracker;
import dev.the_fireplace.lib.domain.config.OptionTypeConverter;
import dev.the_fireplace.lib.domain.config.cloth.OptionBuilderFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleListBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatListBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntListBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongListBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringListBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public final class FabricClothConfigScreenBuilder
implements ConfigScreenBuilder {
    private static final OptionTypeConverter<Short, Integer> SHORT_TYPE_CONVERTER = new OptionTypeConverter<Short, Integer>(){

        @Override
        public Integer convertToClothType(Short source) {
            return (int)source;
        }

        @Override
        public Short convertFromClothType(Integer clothValue) {
            return clothValue.shortValue();
        }
    };
    private static final OptionTypeConverter<Byte, Integer> BYTE_TYPE_CONVERTER = new OptionTypeConverter<Byte, Integer>(){

        @Override
        public Integer convertToClothType(Byte source) {
            return (int)source;
        }

        @Override
        public Byte convertFromClothType(Integer clothValue) {
            return clothValue.byteValue();
        }
    };
    private final Translator translator;
    private final ConfigBuilder configBuilder;
    private final ConfigEntryBuilder entryBuilder;
    private final ClothConfigDependencyHandler dependencyTracker;
    private final OptionBuilderFactory optionBuilderFactory;
    private final Multimap<ConfigCategory, OptionBuilder<?>> categoryEntries;
    private ConfigCategory category;
    private SubCategoryTracker subCategory = null;

    public FabricClothConfigScreenBuilder(OptionBuilderFactory optionBuilderFactory, Translator translator, String titleTranslationKey, String initialCategoryTranslationKey, class_437 parent, Runnable save) {
        this.optionBuilderFactory = optionBuilderFactory;
        this.translator = translator;
        this.configBuilder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)translator.getTranslatedText(titleTranslationKey, new Object[0]));
        this.entryBuilder = this.configBuilder.entryBuilder();
        this.category = this.configBuilder.getOrCreateCategory((class_2561)translator.getTranslatedText(initialCategoryTranslationKey, new Object[0]));
        this.configBuilder.setSavingRunnable(save);
        this.dependencyTracker = new ClothConfigDependencyHandler();
        this.categoryEntries = ArrayListMultimap.create();
    }

    @Override
    public void startCategory(String translationKey, Object ... translationParameters) {
        class_5250 categoryName = this.translator.getTranslatedText(translationKey, translationParameters);
        this.category = this.configBuilder.getOrCreateCategory((class_2561)categoryName);
        if (this.subCategory != null) {
            FireplaceLibConstants.getLogger().warn("Sub-Category {} not explicitly ended before starting a new category! Ending it...", (Object)this.subCategory.getBuilder().getFieldNameKey().method_10851());
            this.endSubCategory();
        }
    }

    @Override
    public void startSubCategory(String translationKey, Object ... translationParameters) {
        this.subCategory = new SubCategoryTracker(new SubCategoryBuilder(this.entryBuilder.getResetButtonKey(), (class_2561)this.translator.getTranslatedText(translationKey, translationParameters)));
        this.categoryEntries.put((Object)this.category, (Object)this.subCategory);
    }

    @Override
    public void endSubCategory() {
        this.subCategory = null;
    }

    @Override
    public OptionBuilder<String> addStringField(String optionTranslationBase, String currentValue, String defaultValue, Consumer<String> saveFunction) {
        StringFieldBuilder builder = this.entryBuilder.startStrField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<String> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public <T extends Enum<T>> OptionBuilder<T> addEnumDropdown(String optionTranslationBase, final T currentValue, T defaultValue, T[] dropdownEntries, Consumer<T> saveFunction) {
        OptionTypeConverter enumTypeConverter = new OptionTypeConverter<T, String>(this){

            @Override
            public String convertToClothType(T source) {
                return ((Enum)source).name();
            }

            @Override
            public T convertFromClothType(String clothValue) {
                return Enum.valueOf(currentValue.getClass(), clothValue);
            }
        };
        DropdownMenuBuilder builder = this.entryBuilder.startStringDropdownMenu((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (String)enumTypeConverter.convertToClothType(currentValue));
        DropdownOptionBuilder<T> optionBuilder = this.optionBuilderFactory.createDropdown(this.translator, builder, optionTranslationBase, defaultValue, Set.of(dropdownEntries), saveFunction, enumTypeConverter);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public DropdownOptionBuilder<String> addStringDropdown(String optionTranslationBase, String currentValue, String defaultValue, Iterable<String> dropdownEntries, Consumer<String> saveFunction) {
        DropdownMenuBuilder builder = this.entryBuilder.startStringDropdownMenu((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        DropdownOptionBuilder<String> optionBuilder = this.optionBuilderFactory.createDropdown(this.translator, builder, optionTranslationBase, defaultValue, dropdownEntries, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<String>> addStringListField(String optionTranslationBase, List<String> currentValue, List<String> defaultValue, Consumer<List<String>> saveFunction) {
        StringListBuilder builder = this.entryBuilder.startStrList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<List<String>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public NumericOptionBuilder<Float> addFloatField(String optionTranslationBase, float currentValue, float defaultValue, Consumer<Float> saveFunction) {
        FloatFieldBuilder builder = this.entryBuilder.startFloatField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        NumericOptionBuilder<Float> optionBuilder = this.optionBuilderFactory.createNumeric(this.translator, builder, optionTranslationBase, Float.valueOf(defaultValue), saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public DecimalSliderOptionBuilder<Float> addFloatSlider(String optionTranslationBase, float currentValue, float defaultValue, Consumer<Float> saveFunction, float min, float max) {
        FloatingPointClothConverter typeConverter = new FloatingPointClothConverter();
        LongSliderBuilder builder = this.entryBuilder.startLongSlider((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), ((Long)typeConverter.convertToClothType(Float.valueOf(currentValue))).longValue(), ((Long)typeConverter.convertToClothType(Float.valueOf(min))).longValue(), ((Long)typeConverter.convertToClothType(Float.valueOf(max))).longValue());
        DecimalSliderOptionBuilder<Float> optionBuilder = this.optionBuilderFactory.createDecimalSlider(this.translator, builder, optionTranslationBase, Float.valueOf(defaultValue), saveFunction, Float.valueOf(currentValue), Float.valueOf(min), Float.valueOf(max), typeConverter);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<Float>> addFloatListField(String optionTranslationBase, List<Float> currentValue, List<Float> defaultValue, Consumer<List<Float>> saveFunction) {
        FloatListBuilder builder = this.entryBuilder.startFloatList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<List<Float>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public NumericOptionBuilder<Double> addDoubleField(String optionTranslationBase, double currentValue, double defaultValue, Consumer<Double> saveFunction) {
        DoubleFieldBuilder builder = this.entryBuilder.startDoubleField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        NumericOptionBuilder<Double> optionBuilder = this.optionBuilderFactory.createNumeric(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public DecimalSliderOptionBuilder<Double> addDoubleSlider(String optionTranslationBase, double currentValue, double defaultValue, Consumer<Double> saveFunction, double min, double max) {
        FloatingPointClothConverter typeConverter = new FloatingPointClothConverter();
        LongSliderBuilder builder = this.entryBuilder.startLongSlider((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), ((Long)typeConverter.convertToClothType(currentValue)).longValue(), ((Long)typeConverter.convertToClothType(min)).longValue(), ((Long)typeConverter.convertToClothType(max)).longValue());
        DecimalSliderOptionBuilder<Double> optionBuilder = this.optionBuilderFactory.createDecimalSlider(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, currentValue, min, max, typeConverter);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<Double>> addDoubleListField(String optionTranslationBase, List<Double> currentValue, List<Double> defaultValue, Consumer<List<Double>> saveFunction) {
        DoubleListBuilder builder = this.entryBuilder.startDoubleList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<List<Double>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public NumericOptionBuilder<Long> addLongField(String optionTranslationBase, long currentValue, long defaultValue, Consumer<Long> saveFunction) {
        LongFieldBuilder builder = this.entryBuilder.startLongField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        NumericOptionBuilder<Long> optionBuilder = this.optionBuilderFactory.createNumeric(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<Long> addLongSlider(String optionTranslationBase, long currentValue, long defaultValue, Consumer<Long> saveFunction, long min, long max) {
        LongSliderBuilder builder = this.entryBuilder.startLongSlider((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue, min, max);
        OptionBuilder<Long> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<Long>> addLongListField(String optionTranslationBase, List<Long> currentValue, List<Long> defaultValue, Consumer<List<Long>> saveFunction) {
        LongListBuilder builder = this.entryBuilder.startLongList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<List<Long>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public NumericOptionBuilder<Integer> addIntField(String optionTranslationBase, int currentValue, int defaultValue, Consumer<Integer> saveFunction) {
        IntFieldBuilder builder = this.entryBuilder.startIntField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        NumericOptionBuilder<Integer> optionBuilder = this.optionBuilderFactory.createNumeric(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<Integer> addIntSlider(String optionTranslationBase, int currentValue, int defaultValue, Consumer<Integer> saveFunction, int min, int max) {
        IntSliderBuilder builder = this.entryBuilder.startIntSlider((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue, min, max);
        OptionBuilder<Integer> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<Integer>> addIntListField(String optionTranslationBase, List<Integer> currentValue, List<Integer> defaultValue, Consumer<List<Integer>> saveFunction) {
        IntListBuilder builder = this.entryBuilder.startIntList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<List<Integer>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public NumericOptionBuilder<Short> addShortField(String optionTranslationBase, short currentValue, short defaultValue, Consumer<Short> saveFunction) {
        IntFieldBuilder builder = this.entryBuilder.startIntField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (int)currentValue);
        NumericOptionBuilder<Short> optionBuilder = this.optionBuilderFactory.createNumeric(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, SHORT_TYPE_CONVERTER);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<Short> addShortSlider(String optionTranslationBase, short currentValue, short defaultValue, Consumer<Short> saveFunction, short min, short max) {
        IntSliderBuilder builder = this.entryBuilder.startIntSlider((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (int)currentValue, (int)min, (int)max);
        OptionBuilder<Short> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, SHORT_TYPE_CONVERTER);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<Short>> addShortListField(String optionTranslationBase, List<Short> currentValue, List<Short> defaultValue, Consumer<List<Short>> saveFunction) {
        OptionTypeConverter<List<Short>, List<Integer>> typeConverter = new OptionTypeConverter<List<Short>, List<Integer>>(this){

            @Override
            public List<Integer> convertToClothType(List<Short> source) {
                return source.stream().map(Integer::valueOf).collect(Collectors.toList());
            }

            @Override
            public List<Short> convertFromClothType(List<Integer> clothValue) {
                return clothValue.stream().map(Integer::shortValue).collect(Collectors.toList());
            }
        };
        IntListBuilder builder = this.entryBuilder.startIntList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (List)typeConverter.convertToClothType(currentValue));
        OptionBuilder<List<Short>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, typeConverter);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public NumericOptionBuilder<Byte> addByteField(String optionTranslationBase, byte currentValue, byte defaultValue, Consumer<Byte> saveFunction) {
        IntFieldBuilder builder = this.entryBuilder.startIntField((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (int)currentValue);
        NumericOptionBuilder<Byte> optionBuilder = this.optionBuilderFactory.createNumeric(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, BYTE_TYPE_CONVERTER);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<Byte> addByteSlider(String optionTranslationBase, byte currentValue, byte defaultValue, Consumer<Byte> saveFunction, byte min, byte max) {
        IntSliderBuilder builder = this.entryBuilder.startIntSlider((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (int)currentValue, (int)min, (int)max);
        OptionBuilder<Byte> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, BYTE_TYPE_CONVERTER);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<List<Byte>> addByteListField(String optionTranslationBase, List<Byte> currentValue, List<Byte> defaultValue, Consumer<List<Byte>> saveFunction) {
        OptionTypeConverter<List<Byte>, List<Integer>> typeConverter = new OptionTypeConverter<List<Byte>, List<Integer>>(this){

            @Override
            public List<Integer> convertToClothType(List<Byte> source) {
                return source.stream().map(Integer::valueOf).collect(Collectors.toList());
            }

            @Override
            public List<Byte> convertFromClothType(List<Integer> clothValue) {
                return clothValue.stream().map(Integer::byteValue).collect(Collectors.toList());
            }
        };
        IntListBuilder builder = this.entryBuilder.startIntList((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), (List)typeConverter.convertToClothType(currentValue));
        OptionBuilder<List<Byte>> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction, typeConverter);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public OptionBuilder<Boolean> addBoolToggle(String optionTranslationBase, boolean currentValue, boolean defaultValue, Consumer<Boolean> saveFunction) {
        BooleanToggleBuilder builder = this.entryBuilder.startBooleanToggle((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue);
        OptionBuilder<Boolean> optionBuilder = this.optionBuilderFactory.create(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    @Override
    public <T extends class_437> CustomButtonBuilder<String> addCustomOptionButton(String optionTranslationBase, String currentValue, String defaultValue, Consumer<String> saveFunction, CustomButtonScreenFactory<String, T> buildOptionScreenFactory) {
        CustomButtonFieldBuilder builder = new CustomButtonFieldBuilder(this.entryBuilder.getResetButtonKey(), (class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), currentValue, buildOptionScreenFactory);
        CustomButtonOption optionBuilder = new CustomButtonOption(this.translator, builder, optionTranslationBase, defaultValue, saveFunction);
        this.registerBuilder(optionBuilder);
        return optionBuilder;
    }

    private void registerBuilder(OptionBuilder<?> optionBuilder) {
        this.categoryEntries.put((Object)this.category, optionBuilder);
        if (this.subCategory != null) {
            this.subCategory.addEntry(optionBuilder);
        }
    }

    @Override
    public class_437 build() {
        HashMap builtOptions = new HashMap();
        for (Map.Entry categoryEntries : this.categoryEntries.asMap().entrySet()) {
            builtOptions.putAll(this.buildCategory((ConfigCategory)categoryEntries.getKey(), (Collection)categoryEntries.getValue()));
        }
        for (Map.Entry categoryEntries : this.categoryEntries.asMap().entrySet()) {
            this.buildDependencies((Collection)categoryEntries.getValue(), builtOptions);
        }
        return this.configBuilder.build();
    }

    private void buildDependencies(Collection<OptionBuilder<?>> optionBuilders, Map<OptionBuilder<?>, AbstractConfigListEntry<?>> builtOptions) {
        for (OptionBuilder<?> optionBuilder : optionBuilders) {
            if (!(optionBuilder instanceof ClothGenericOption)) continue;
            ClothGenericOption clothGenericOption = (ClothGenericOption)optionBuilder;
            clothGenericOption.getDependencies().forEach((key, value) -> this.dependencyTracker.addDependency((AbstractConfigListEntry)builtOptions.get(key), (AbstractConfigListEntry)builtOptions.get(optionBuilder), (Predicate)value));
        }
    }

    private Map<OptionBuilder<?>, AbstractConfigListEntry<?>> buildCategory(ConfigCategory configCategory, Collection<OptionBuilder<?>> optionBuilders) {
        HashMap builtOptions = new HashMap();
        SubCategoryTracker subCategoryTracker = null;
        for (OptionBuilder<?> optionBuilder : optionBuilders) {
            if (optionBuilder instanceof ClothGenericOption) {
                ClothGenericOption clothGenericOption = (ClothGenericOption)optionBuilder;
                AbstractConfigListEntry configListEntry = clothGenericOption.getFieldBuilder().build();
                this.dependencyTracker.addOption(configListEntry, clothGenericOption.getTypeConverter());
                builtOptions.put(optionBuilder, configListEntry);
                if (subCategoryTracker != null) {
                    subCategoryTracker.getBuilder().add(configListEntry);
                    if (subCategoryTracker.getLastEntry() != optionBuilder) continue;
                    this.finishSubCategory(configCategory, subCategoryTracker);
                    subCategoryTracker = null;
                    continue;
                }
                configCategory.addEntry(configListEntry);
                continue;
            }
            if (!(optionBuilder instanceof SubCategoryTracker) || (subCategoryTracker = (SubCategoryTracker)optionBuilder).hasEntries()) continue;
            this.finishSubCategory(configCategory, subCategoryTracker);
            subCategoryTracker = null;
        }
        return builtOptions;
    }

    private void finishSubCategory(ConfigCategory configCategory, SubCategoryTracker tracker) {
        configCategory.addEntry((AbstractConfigListEntry)tracker.getBuilder().build());
    }
}

