/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth.custombutton;

import com.google.common.collect.Lists;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonScreen;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonScreenFactory;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import dev.the_fireplace.lib.config.cloth.ClothConfigDependencyHandler;
import io.netty.util.concurrent.Promise;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_6379;

@Environment(value=EnvType.CLIENT)
public class CustomButtonEntry
extends TooltipListEntry<String> {
    private final AtomicReference<String> value;
    private final String original;
    private final class_4185 buttonWidget;
    private final class_4185 resetButton;
    private final Consumer<String> saveConsumer;
    private final Supplier<String> defaultValue;
    private final List<class_339> widgets;
    private final Function<String, class_2561> getDisplayText;
    private final CustomButtonScreenFactory<String, ?> buildOptionScreenFactory;

    public CustomButtonEntry(class_2561 fieldName, String currentValue, class_2561 resetButtonKey, Supplier<String> defaultValue, Consumer<String> saveConsumer, CustomButtonScreenFactory<String, ?> buildOptionScreenFactory, Function<String, class_2561> getDisplayText) {
        super(fieldName, null);
        this.defaultValue = defaultValue;
        this.original = currentValue;
        this.value = new AtomicReference<String>(currentValue);
        this.buildOptionScreenFactory = buildOptionScreenFactory;
        this.buttonWidget = class_4185.method_46430((class_2561)class_2561.method_43473(), this::openOptionScreen).method_46433(0, 0).method_46437(150, 20).method_46431();
        this.resetButton = class_4185.method_46430((class_2561)resetButtonKey, this::reset).method_46433(0, 0).method_46437(class_310.method_1551().field_1772.method_27525((class_5348)resetButtonKey) + 6, 20).method_46431();
        this.saveConsumer = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new class_339[]{this.buttonWidget, this.resetButton});
        this.getDisplayText = getDisplayText;
    }

    public void openOptionScreen(class_4185 button) {
        Object optionBuilderScreen = this.buildOptionScreenFactory.createScreen(class_310.method_1551().field_1755, this.value.get());
        Promise willReturnNewValuePromise = ((CustomButtonScreen)optionBuilderScreen).getNewValuePromise();
        class_310.method_1551().method_1507(optionBuilderScreen);
        ((ExecutionManager)FireplaceLibConstants.getInjector().getInstance(ExecutionManager.class)).runKillable(() -> {
            Optional builderReturnedValue = Optional.empty();
            try {
                builderReturnedValue = (Optional)willReturnNewValuePromise.get();
            }
            catch (InterruptedException | ExecutionException e) {
                FireplaceLibConstants.getLogger().error((Object)e);
            }
            builderReturnedValue.ifPresent(this.value::set);
        });
    }

    public void reset(class_4185 button) {
        this.value.set(this.defaultValue.get());
    }

    public boolean isEdited() {
        return super.isEdited() || !Objects.equals(this.original, this.value.get());
    }

    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public String getValue() {
        return this.value.get();
    }

    public Optional<String> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public void render(class_332 guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        if (ClothConfigDependencyHandler.DISABLED_ENTRIES.contains((Object)this)) {
            return;
        }
        super.render(guiGraphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        class_1041 window = class_310.method_1551().method_22683();
        this.resetButton.field_22763 = this.isEditable() && this.getDefaultValue().isPresent() && !Objects.equals(this.defaultValue.get(), this.value.get());
        this.resetButton.method_46419(y);
        this.buttonWidget.field_22763 = this.isEditable();
        this.buttonWidget.method_46419(y);
        class_2561 buttonText = this.getDisplayText != null ? this.getDisplayText.apply(this.value.get()) : class_2561.method_30163((String)this.value.get());
        this.buttonWidget.method_25355(buttonText);
        class_2561 displayedFieldName = this.getDisplayedFieldName();
        class_327 font = class_310.method_1551().field_1772;
        if (font.method_1726()) {
            guiGraphics.method_35720(font, displayedFieldName.method_30937(), window.method_4486() - x - font.method_27525((class_5348)displayedFieldName), y + 6, this.getPreferredTextColor());
            this.resetButton.method_46421(x);
            this.buttonWidget.method_46421(x + this.resetButton.method_25368() + 2);
        } else {
            guiGraphics.method_35720(font, displayedFieldName.method_30937(), x, y + 6, this.getPreferredTextColor());
            this.resetButton.method_46421(x + entryWidth - this.resetButton.method_25368());
            this.buttonWidget.method_46421(x + entryWidth - 150);
        }
        this.buttonWidget.method_25358(150 - this.resetButton.method_25368() - 2);
        this.resetButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.buttonWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public List<? extends class_6379> narratables() {
        return this.widgets;
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }
}

