/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io.access;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import dev.the_fireplace.lib.domain.io.JsonBufferDiffGenerator;
import dev.the_fireplace.lib.io.access.JsonStorageWriteBuffer;
import dev.the_fireplace.lib.io.access.SimpleJsonBuffer;
import java.lang.reflect.Type;
import java.util.Map;

@Implementation
public final class JsonBufferDiffGeneratorImpl
implements JsonBufferDiffGenerator {
    @Override
    public SimpleBuffer generateLeftDiff(JsonStorageWriteBuffer buffer1, JsonStorageWriteBuffer buffer2) {
        if (buffer1.getObj() == buffer2.getObj()) {
            return new SimpleJsonBuffer(new JsonObject());
        }
        Gson g = new Gson();
        Type mapType = new TypeToken<Map<String, JsonElement>>(this){}.getType();
        Map firstMap = (Map)g.fromJson((JsonElement)buffer1.getObj(), mapType);
        Map secondMap = (Map)g.fromJson((JsonElement)buffer2.getObj(), mapType);
        MapDifference diff = Maps.difference((Map)firstMap, (Map)secondMap);
        JsonObject diffOutput = new JsonObject();
        for (Map.Entry entry : diff.entriesDiffering().entrySet()) {
            diffOutput.add((String)entry.getKey(), (JsonElement)((MapDifference.ValueDifference)entry.getValue()).leftValue());
        }
        for (Map.Entry entry : diff.entriesOnlyOnLeft().entrySet()) {
            diffOutput.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        for (String entryKey : diff.entriesOnlyOnRight().keySet()) {
            diffOutput.add(entryKey, null);
        }
        return new SimpleJsonBuffer(diffOutput);
    }
}

