/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io.access;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class JsonStorageReadBuffer
implements StorageReadBuffer {
    private final JsonObject obj;

    JsonStorageReadBuffer(JsonObject obj) {
        this.obj = obj;
    }

    @Override
    public UUID readUUID(String key, UUID ifAbsent) {
        if (this.obj.has(key)) {
            String uuidString = this.obj.get(key).getAsString();
            try {
                return UUID.fromString(uuidString);
            }
            catch (IllegalArgumentException e) {
                FireplaceLibConstants.getLogger().warn("Expected UUID for key '{}', got '{}'. Using default data instead.", (Object)key, (Object)uuidString);
            }
        }
        return ifAbsent;
    }

    @Override
    public String readString(String key, String ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsString() : ifAbsent;
    }

    @Override
    public long readLong(String key, long ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsLong() : ifAbsent;
    }

    @Override
    public int readInt(String key, int ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsInt() : ifAbsent;
    }

    @Override
    public short readShort(String key, short ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsShort() : ifAbsent;
    }

    @Override
    public byte readByte(String key, byte ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsByte() : ifAbsent;
    }

    @Override
    public double readDouble(String key, double ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsDouble() : ifAbsent;
    }

    @Override
    public float readFloat(String key, float ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsFloat() : ifAbsent;
    }

    @Override
    public boolean readBool(String key, boolean ifAbsent) {
        return this.obj.has(key) ? this.obj.get(key).getAsBoolean() : ifAbsent;
    }

    @Override
    public List<Boolean> readBoolList(String key, List<Boolean> ifAbsent) {
        if (!this.obj.has(key)) {
            return ifAbsent;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        JsonArray array = this.obj.getAsJsonArray(key);
        for (JsonElement element : array) {
            list.add(element.getAsBoolean());
        }
        return list;
    }

    @Override
    public List<Number> readNumberList(String key, List<Number> ifAbsent) {
        if (!this.obj.has(key)) {
            return ifAbsent;
        }
        ArrayList<Number> list = new ArrayList<Number>();
        JsonArray array = this.obj.getAsJsonArray(key);
        for (JsonElement element : array) {
            list.add(element.getAsNumber());
        }
        return list;
    }

    @Override
    public List<String> readStringList(String key, List<String> ifAbsent) {
        if (!this.obj.has(key)) {
            return ifAbsent;
        }
        ArrayList<String> list = new ArrayList<String>();
        JsonArray array = this.obj.getAsJsonArray(key);
        for (JsonElement element : array) {
            list.add(element.getAsString());
        }
        return list;
    }

    @Override
    public Map<String, String> readStringToStringMap(String key, Map<String, String> ifAbsent) {
        if (!this.obj.has(key)) {
            return ifAbsent;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JsonArray array = this.obj.getAsJsonArray(key);
        for (JsonElement element : array) {
            JsonObject object = element.getAsJsonObject();
            map.put(object.get("key").getAsString(), object.get("value").getAsString());
        }
        return map;
    }

    @Override
    public Collection<String> getKeys() {
        return this.obj.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

