/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.lazyio;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.lazyio.injectables.SaveTimer;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import io.netty.util.internal.ConcurrentSet;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Implementation
public final class SaveTimerImpl
implements SaveTimer {
    private final Map<Short, Set<Runnable>> saveIntervalFunctions = new ConcurrentHashMap<Short, Set<Runnable>>();
    private Timer timer = new Timer("FireplaceLib-SaveTimer", true);
    private final ExecutionManager executionManager;

    @Inject
    public SaveTimerImpl(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    @Override
    public void register(short saveIntervalInMinutes, Runnable ... saveRunnables) {
        if (saveIntervalInMinutes < 1) {
            throw new IllegalArgumentException("Save interval must be at least one minute!");
        }
        if (saveRunnables.length == 0) {
            throw new IllegalArgumentException("Must be registering at least one save runnable!");
        }
        Collections.addAll(this.saveIntervalFunctions.computeIfAbsent(saveIntervalInMinutes, newSaveIntervalInMinutes -> {
            this.addIntervalToTimer((short)newSaveIntervalInMinutes);
            return new ConcurrentSet();
        }), saveRunnables);
    }

    private void addIntervalToTimer(final short newSaveIntervalInMinutes) {
        int saveIntervalInMilliseconds = 60000 * newSaveIntervalInMinutes;
        int randomOffset = 200 + new Random().nextInt(59800);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (Runnable runnable : SaveTimerImpl.this.saveIntervalFunctions.get(newSaveIntervalInMinutes)) {
                    SaveTimerImpl.this.executionManager.run(runnable);
                }
            }
        }, saveIntervalInMilliseconds - randomOffset, (long)saveIntervalInMilliseconds);
    }

    @Override
    public void unregister(short saveIntervalInMinutes, Runnable ... saveRunnables) {
        if (!this.saveIntervalFunctions.containsKey(saveIntervalInMinutes)) {
            FireplaceLibConstants.getLogger().warn("Attempted to remove save runnables from invalid time interval.", (Throwable)new Exception("Stack Trace"));
            return;
        }
        if (saveRunnables.length == 0) {
            throw new IllegalArgumentException("Must be unregistering at least one save runnable!");
        }
        this.saveIntervalFunctions.get(saveIntervalInMinutes).removeAll(Set.of(saveRunnables));
    }

    @Override
    public void prepareForServerShutdown() {
        this.timer.cancel();
        this.saveAll();
    }

    @Override
    public void resetTimer() {
        this.timer = new Timer("FireplaceLib-SaveTimer", true);
    }

    private void saveAll() {
        for (Set<Runnable> intervalRunnables : this.saveIntervalFunctions.values()) {
            for (Runnable runnable : intervalRunnables) {
                this.executionManager.run(runnable);
            }
        }
    }
}

