/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.lazyio.hierarchicalconfig;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ReloadableManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.lib.api.lazyio.interfaces.Reloadable;
import dev.the_fireplace.lib.domain.io.HierarchicalConfigReader;
import dev.the_fireplace.lib.domain.io.HierarchicalConfigWriter;
import dev.the_fireplace.lib.domain.io.JsonBufferDiffGenerator;
import dev.the_fireplace.lib.io.access.JsonStorageWriteBuffer;
import dev.the_fireplace.lib.io.access.SchemaValidator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_2960;

@Singleton
public final class HierarchicalConfigLoader {
    private final HierarchicalConfigReader storageReader;
    private final HierarchicalConfigWriter storageWriter;
    private final ReloadableManager reloadableManager;
    private final JsonBufferDiffGenerator bufferDiffGenerator;
    private final Map<String, Reloadable> configReloaders;

    @Inject
    public HierarchicalConfigLoader(HierarchicalConfigReader storageReader, HierarchicalConfigWriter storageWriter, ReloadableManager reloadableManager, JsonBufferDiffGenerator bufferDiffGenerator) {
        this.storageReader = storageReader;
        this.storageWriter = storageWriter;
        this.reloadableManager = reloadableManager;
        this.bufferDiffGenerator = bufferDiffGenerator;
        this.configReloaders = new ConcurrentHashMap<String, Reloadable>();
    }

    public <T extends HierarchicalConfig> T initialize(T config, String domain, String id) {
        this.load(config, domain, id);
        this.save(config, domain, id);
        this.registerReloadable(config, domain, id);
        return config;
    }

    public <T extends HierarchicalConfig> T initialize(T config, String domain, class_2960 id) {
        this.load(config, domain, id);
        this.save(config, domain, id);
        this.registerReloadable(config, domain, id);
        return config;
    }

    private void registerReloadable(HierarchicalConfig config, String domain, String id) {
        String reloadId = this.getReloadId(domain, id);
        if (reloadId.isEmpty()) {
            FireplaceLibConstants.getLogger().warn("Hierarchical Config was registered without ID or Domain, unable to register reloadable!", (Throwable)new Exception("Stacktrace"));
            return;
        }
        Reloadable configReloader = this.buildConfigReloadable(config, domain, id, reloadId);
        this.registerReloader(reloadId, configReloader);
    }

    private void registerReloadable(HierarchicalConfig config, String domain, class_2960 id) {
        String reloadId = this.getReloadId(domain, id);
        if (reloadId.isEmpty()) {
            FireplaceLibConstants.getLogger().warn("Hierarchical Config was registered without ID or Domain, unable to register reloadable!", (Throwable)new Exception("Stacktrace"));
            return;
        }
        Reloadable configReloader = this.buildConfigReloadable(config, domain, id, reloadId);
        this.registerReloader(reloadId, configReloader);
    }

    private void registerReloader(String reloadId, Reloadable configReloader) {
        Reloadable oldReloader = this.configReloaders.get(reloadId);
        if (oldReloader != null) {
            this.reloadableManager.unregister(oldReloader);
        }
        this.configReloaders.put(reloadId, configReloader);
        this.reloadableManager.register(configReloader);
    }

    private Reloadable buildConfigReloadable(final HierarchicalConfig config, final String domain, final String id, final String reloadId) {
        return new Reloadable(){

            @Override
            public void reload() {
                JsonStorageWriteBuffer previousState = new JsonStorageWriteBuffer();
                config.writeTo(previousState);
                HierarchicalConfigLoader.this.reload(config, domain, id);
                JsonStorageWriteBuffer currentState = new JsonStorageWriteBuffer();
                config.writeTo(currentState);
                SimpleBuffer diffBuffer = HierarchicalConfigLoader.this.bufferDiffGenerator.generateLeftDiff(previousState, currentState);
                config.afterReload(diffBuffer);
            }

            @Override
            public String getReloadGroup() {
                return !domain.isEmpty() ? domain : reloadId;
            }
        };
    }

    private Reloadable buildConfigReloadable(final HierarchicalConfig config, final String domain, final class_2960 id, final String reloadId) {
        return new Reloadable(){

            @Override
            public void reload() {
                JsonStorageWriteBuffer previousState = new JsonStorageWriteBuffer();
                config.writeTo(previousState);
                HierarchicalConfigLoader.this.reload(config, domain, id);
                JsonStorageWriteBuffer currentState = new JsonStorageWriteBuffer();
                config.writeTo(currentState);
                SimpleBuffer diffBuffer = HierarchicalConfigLoader.this.bufferDiffGenerator.generateLeftDiff(previousState, currentState);
                config.afterReload(diffBuffer);
            }

            @Override
            public String getReloadGroup() {
                return !domain.isEmpty() ? domain : reloadId;
            }
        };
    }

    private String getReloadId(String domain, String id) {
        String configId;
        StringBuilder reloadId = new StringBuilder();
        String subFolder = this.validateConfigName(domain);
        if (!subFolder.isEmpty()) {
            reloadId.append(subFolder).append("/");
        }
        if (!(configId = this.validateConfigName(id)).isEmpty()) {
            reloadId.append(configId);
        }
        return reloadId.toString();
    }

    private String getReloadId(String domain, class_2960 id) {
        String configId;
        String configNamespace;
        StringBuilder reloadId = new StringBuilder();
        String subFolder = this.validateConfigName(domain);
        if (!subFolder.isEmpty()) {
            reloadId.append(subFolder).append("/");
        }
        if (!(configNamespace = this.validateConfigName(id.method_12836())).isEmpty()) {
            reloadId.append(configNamespace).append(":");
        }
        if (!(configId = this.validateConfigName(id.method_12832())).isEmpty()) {
            reloadId.append(configId);
        }
        return reloadId.toString();
    }

    private String validateConfigName(String domain) {
        return SchemaValidator.isValid(domain) ? SchemaValidator.minimizeSchema(domain) : "";
    }

    public void load(HierarchicalConfig config, String domain, String id) {
        this.storageReader.readTo(config, domain, id);
    }

    public void load(HierarchicalConfig config, String domain, class_2960 id) {
        this.storageReader.readTo(config, domain, id);
    }

    public void save(HierarchicalConfig config, String domain, String id) {
        this.storageWriter.write(config, domain, id);
    }

    public void save(HierarchicalConfig config, String domain, class_2960 id) {
        this.storageWriter.write(config, domain, id);
    }

    private void reload(HierarchicalConfig config, String domain, String id) {
        this.load(config, domain, id);
    }

    private void reload(HierarchicalConfig config, String domain, class_2960 id) {
        this.load(config, domain, id);
    }

    public boolean delete(String domain, String id) {
        boolean deleted = this.storageWriter.delete(domain, id);
        if (deleted) {
            String reloadId = this.getReloadId(domain, id);
            this.configReloaders.remove(reloadId);
        }
        return deleted;
    }

    public boolean delete(String domain, class_2960 id) {
        boolean deleted = this.storageWriter.delete(domain, id);
        if (deleted) {
            String reloadId = this.getReloadId(domain, id);
            this.configReloaders.remove(reloadId);
        }
        return deleted;
    }
}

