/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.network.injectables.PacketSpecificationRegistry;
import dev.the_fireplace.lib.api.network.interfaces.ClientboundPacketReceiver;
import dev.the_fireplace.lib.domain.network.FabricChannelManager;
import dev.the_fireplace.lib.domain.network.NetworkRegister;
import dev.the_fireplace.lib.network.FabricPacketChannel;
import jakarta.inject.Singleton;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Singleton
@Implementation(allInterfaces=true, environment="CLIENT")
public final class FabricClientPacketChannel
extends FabricPacketChannel
implements FabricChannelManager,
PacketSpecificationRegistry,
NetworkRegister {
    @Override
    protected void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver(FabricPacketChannel.ReceiverWrapper.TYPE, (payload, context) -> {
            FabricPacketChannel.ReceiverWrapper.Data packetData = payload.unwrap();
            class_2960 packetId = packetData.packetId();
            this.getClientReceiver(packetId).ifPresent(clientReceiver -> {
                class_310 client = class_310.method_1551();
                class_2540 packetContents = packetData.packetContents();
                ((ClientboundPacketReceiver)clientReceiver.get()).receive(client, client.method_1562(), packetContents);
                int unreadBytes = packetContents.readableBytes();
                if (unreadBytes > 0) {
                    FireplaceLibConstants.getLogger().error("Packet {} was larger than expected, found {} bytes extra", (Object)packetId.toString(), (Object)unreadBytes);
                }
            });
        });
    }
}

