/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.network.injectables.PacketSpecificationRegistry;
import dev.the_fireplace.lib.api.network.interfaces.PacketSpecification;
import dev.the_fireplace.lib.api.network.interfaces.ServerboundPacketReceiver;
import dev.the_fireplace.lib.domain.network.FabricChannelManager;
import dev.the_fireplace.lib.domain.network.NetworkRegister;
import dev.the_fireplace.lib.network.PacketReceiverRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.inject.Singleton;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

@Singleton
@Implementation(allInterfaces=true, environment="SERVER")
public class FabricPacketChannel
extends PacketReceiverRegistry
implements FabricChannelManager,
PacketSpecificationRegistry,
NetworkRegister {
    @Override
    public final void register() {
        PayloadTypeRegistry.playC2S().register(ReceiverWrapper.TYPE, ReceiverWrapper.CODEC);
        PayloadTypeRegistry.playS2C().register(ReceiverWrapper.TYPE, ReceiverWrapper.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ReceiverWrapper.TYPE, (payload, context) -> {
            ReceiverWrapper.Data packetData = payload.unwrap();
            class_2960 packetId = packetData.packetId();
            this.getServerReceiver(packetId).ifPresent(serverReceiver -> {
                class_3222 sender = context.player();
                if (sender != null) {
                    class_2540 packetContents = packetData.packetContents();
                    ((ServerboundPacketReceiver)serverReceiver.get()).receive(sender.field_13995, sender, sender.field_13987, packetContents);
                    int unreadBytes = packetContents.readableBytes();
                    if (unreadBytes > 0) {
                        FireplaceLibConstants.getLogger().error("Packet {} was larger than expected, found {} bytes extra", (Object)packetId.toString(), (Object)unreadBytes);
                    }
                }
            });
        });
        this.registerClient();
    }

    protected void registerClient() {
    }

    @Override
    public class_8710 wrap(PacketSpecification specification, class_2540 packetContents) {
        class_2540 wrappedPacketContents = new class_2540(Unpooled.buffer());
        wrappedPacketContents.method_10812(specification.getPacketID());
        wrappedPacketContents.method_52975((ByteBuf)packetContents);
        return new ReceiverWrapper(wrappedPacketContents);
    }

    protected static class ReceiverWrapper
    implements class_8710 {
        private static final class_9139<class_2540, ReceiverWrapper> CODEC = class_8710.method_56484((receiverWrapper, outputByteBuf) -> outputByteBuf.method_52975((ByteBuf)receiverWrapper.buffer), ReceiverWrapper::new);
        protected static final class_8710.class_9154<ReceiverWrapper> TYPE = class_8710.method_56483((String)FireplaceLibConstants.PACKET_CHANNEL_ID.toString());
        private final class_2540 buffer;

        private ReceiverWrapper(class_2540 buffer) {
            this.buffer = new class_2540(buffer.copy());
            buffer.method_52931();
        }

        protected Data unwrap() {
            class_2960 packetId = this.buffer.method_10810();
            class_2540 packetContents = new class_2540(this.buffer.copy());
            return new Data(packetId, packetContents);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        protected record Data(class_2960 packetId, class_2540 packetContents) {
        }
    }
}

