/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.network.injectables.PacketSender;
import dev.the_fireplace.lib.api.network.interfaces.PacketSpecification;
import dev.the_fireplace.lib.domain.network.FabricChannelManager;
import dev.the_fireplace.lib.domain.network.ServerboundSender;
import javax.inject.Inject;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;

@Implementation
public final class FabricPacketSender
implements PacketSender {
    private final ServerboundSender serverboundSender;
    private final FabricChannelManager channelManager;

    @Inject
    public FabricPacketSender(ServerboundSender serverboundSender, FabricChannelManager channelManager) {
        this.serverboundSender = serverboundSender;
        this.channelManager = channelManager;
    }

    @Override
    public void sendToServer(PacketSpecification specification, class_2540 packetContents) {
        this.serverboundSender.sendToServer(specification, packetContents);
    }

    @Override
    public void sendToClient(class_3244 connection, PacketSpecification specification, class_2540 packetContents) {
        if (ServerPlayNetworking.canSend((class_3244)connection, (class_2960)FireplaceLibConstants.PACKET_CHANNEL_ID)) {
            ServerPlayNetworking.send((class_3222)connection.field_14140, (class_8710)this.channelManager.wrap(specification, packetContents));
        } else if (!specification.shouldSilentlyFailOnMissingReceiver()) {
            throw new IllegalStateException(String.format("Player %s is missing a receiver for packet %s.", connection.field_14140.method_7334().getName(), specification.getPacketID().toString()));
        }
    }
}

