/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.network.interfaces.PacketSpecification;
import dev.the_fireplace.lib.domain.network.FabricChannelManager;
import dev.the_fireplace.lib.domain.network.ServerboundSender;
import jakarta.inject.Inject;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

@Implementation(environment="CLIENT")
public final class FabricServerboundPacketSender
implements ServerboundSender {
    private final FabricChannelManager channelManager;

    @Inject
    public FabricServerboundPacketSender(FabricChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    @Override
    public void sendToServer(PacketSpecification specification, class_2540 packetContents) {
        if (ClientPlayNetworking.canSend((class_2960)FireplaceLibConstants.PACKET_CHANNEL_ID)) {
            ClientPlayNetworking.send((class_8710)this.channelManager.wrap(specification, packetContents));
        } else if (!specification.shouldSilentlyFailOnMissingReceiver()) {
            throw new IllegalStateException(String.format("The server is missing a receiver for packet %s.", specification.getPacketID().toString()));
        }
    }
}

