/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.lib.api.network.injectables.PacketSpecificationRegistry;
import dev.the_fireplace.lib.api.network.interfaces.ClientboundPacketReceiver;
import dev.the_fireplace.lib.api.network.interfaces.ClientboundPacketSpecification;
import dev.the_fireplace.lib.api.network.interfaces.ServerboundPacketReceiver;
import dev.the_fireplace.lib.api.network.interfaces.ServerboundPacketSpecification;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public abstract class PacketReceiverRegistry
implements PacketSpecificationRegistry {
    private final Map<class_2960, Supplier<ClientboundPacketReceiver>> clientReceivers = new ConcurrentHashMap<class_2960, Supplier<ClientboundPacketReceiver>>();
    private final Map<class_2960, Supplier<ServerboundPacketReceiver>> serverReceivers = new ConcurrentHashMap<class_2960, Supplier<ServerboundPacketReceiver>>();

    @Override
    public void register(ServerboundPacketSpecification specification) {
        this.serverReceivers.put(specification.getPacketID(), specification.getReceiverFactory());
    }

    @Override
    public void register(ClientboundPacketSpecification specification) {
        this.clientReceivers.put(specification.getPacketID(), specification.getReceiverFactory());
    }

    protected Optional<Supplier<ClientboundPacketReceiver>> getClientReceiver(class_2960 packetId) {
        return Optional.ofNullable(this.clientReceivers.get(packetId));
    }

    protected Optional<Supplier<ServerboundPacketReceiver>> getServerReceiver(class_2960 packetId) {
        return Optional.ofNullable(this.serverReceivers.get(packetId));
    }
}

