/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.player;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.player.injectables.GameProfileFinder;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_3312;

@Singleton
@Implementation(environment="CLIENT")
public final class ClientGameProfileFinder
implements GameProfileFinder {
    private final EmptyUUID emptyUUID;
    private final class_310 client;
    private final Map<UUID, Optional<GameProfile>> profilesById = new ConcurrentHashMap<UUID, Optional<GameProfile>>();
    private final Map<String, Optional<GameProfile>> profilesByName = new ConcurrentHashMap<String, Optional<GameProfile>>();

    @Inject
    public ClientGameProfileFinder(EmptyUUID emptyUUID) {
        this.emptyUUID = emptyUUID;
        this.client = class_310.method_1551();
    }

    @Override
    public Optional<GameProfile> findProfile(UUID playerId) {
        Optional<GameProfile> wrappedProfile;
        GameProfile profile;
        if (this.emptyUUID.is(playerId)) {
            return Optional.empty();
        }
        if (this.profilesById.containsKey(playerId)) {
            return this.profilesById.get(playerId);
        }
        ProfileResult profileResult = this.client.method_1495().fetchProfile(playerId, false);
        GameProfile gameProfile = profile = profileResult != null ? profileResult.profile() : null;
        if (profile == null || profile.getName().isEmpty()) {
            wrappedProfile = Optional.empty();
        } else {
            wrappedProfile = Optional.of(profile);
            this.profilesByName.put(profile.getName(), wrappedProfile);
        }
        this.profilesById.put(playerId, wrappedProfile);
        return wrappedProfile;
    }

    @Override
    public Optional<GameProfile> findProfile(String playerName) {
        if (playerName.isEmpty()) {
            return Optional.empty();
        }
        if (this.profilesByName.containsKey(playerName)) {
            return this.profilesByName.get(playerName);
        }
        class_1132 server = this.client.method_1576();
        if (server != null) {
            class_3312.method_14510((boolean)true);
            Optional foundProfile = server.method_3793().method_14515(playerName);
            this.profilesByName.put(playerName, foundProfile);
            return foundProfile;
        }
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            JsonObject object = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(con.getInputStream()), JsonObject.class);
            con.disconnect();
            if (object.has("id")) {
                Optional<GameProfile> gameProfile = this.findProfile(UUID.fromString(object.get("id").getAsString()));
                this.profilesByName.put(playerName, gameProfile);
            } else {
                this.profilesByName.put(playerName, Optional.empty());
            }
        }
        catch (IOException e) {
            this.profilesByName.put(playerName, Optional.empty());
        }
        return this.profilesByName.get(playerName);
    }
}

