/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.player;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.player.injectables.GameProfileFinder;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import net.minecraft.class_3312;
import net.minecraft.server.MinecraftServer;

@Implementation(environment="SERVER")
public final class DedicatedServerGameProfileFinder
implements GameProfileFinder {
    private final EmptyUUID emptyUUID;
    private final class_3312 userCache;
    private final MinecraftSessionService sessionService;
    private final Set<UUID> uuidsWithoutProfiles = new HashSet<UUID>();
    private final Set<String> namesWithoutProfiles = new HashSet<String>();

    @Inject
    public DedicatedServerGameProfileFinder(EmptyUUID emptyUUID) {
        this.emptyUUID = emptyUUID;
        MinecraftServer server = FireplaceLibConstants.getServer();
        this.userCache = server.method_3793();
        this.sessionService = server.method_3844();
    }

    @Override
    public Optional<GameProfile> findProfile(UUID playerId) {
        GameProfile profile;
        if (this.emptyUUID.is(playerId)) {
            return Optional.empty();
        }
        if (this.uuidsWithoutProfiles.contains(playerId)) {
            return Optional.empty();
        }
        Optional cachedProfile = this.userCache.method_14512(playerId);
        if (cachedProfile.isPresent()) {
            return cachedProfile;
        }
        ProfileResult profileResult = this.sessionService.fetchProfile(playerId, false);
        GameProfile gameProfile = profile = profileResult != null ? profileResult.profile() : null;
        if (profile == null || profile.getName().isEmpty()) {
            this.uuidsWithoutProfiles.add(playerId);
            return Optional.empty();
        }
        this.userCache.method_14508(profile);
        return Optional.of(profile);
    }

    @Override
    public Optional<GameProfile> findProfile(String playerName) {
        if (this.namesWithoutProfiles.contains(playerName) || playerName.isEmpty()) {
            return Optional.empty();
        }
        class_3312.method_14510((boolean)true);
        Optional profile = this.userCache.method_14515(playerName);
        if (profile.isEmpty()) {
            this.namesWithoutProfiles.add(playerName);
        }
        return profile;
    }
}

