package dev.the_fireplace.lib.api.datagen.injectables;

import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.class_2403;

public interface DataGeneratorFactory {
    /**
     * @see DataGeneratorFactory#createAdditive(Path, Collection)
     */
    class_2403 createAdditive(Path outputDirectory);
    /**
     * Create a data generator that will only delete existing files from the target directory if they're being replaced
     */
    class_2403 createAdditive(Path outputDirectory, Collection<Path> nbtProviderInputs);

    /**
     * @see DataGeneratorFactory#createDestructive(Path, Collection)
     */
    class_2403 createDestructive(Path outputDirectory);
    /**
     * Create a data generator that will always delete previously existing files from the target directory before generating
     */
    class_2403 createDestructive(Path outputDirectory, Collection<Path> nbtProviderInputs);
}
