package dev.the_fireplace.lib.api.inventory.injectables;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

public interface InventorySearcher
{
    boolean hasSlotMatching(class_1263 inventory, Predicate<class_1799> matcher);

    Optional<Integer> findFirstMatchingSlot(class_1263 inventory, Predicate<class_1799> matcher);

    List<Integer> findMatchingSlots(class_1263 inventory, Predicate<class_1799> matcher);

    /**
     * Multimap of Priority -> Slot
     */
    Multimap<Integer, Integer> getMatchingSlotsByPriority(class_1263 inventory, Predicate<class_1799> matcher, ToIntFunction<class_1799> priorityMapper);

    /**
     * Multimap of Priority -> Slot
     */
    Multimap<Integer, Integer> getSlotsByPriority(class_1263 inventory, ToIntFunction<class_1799> priorityMapper);
}
