package dev.the_fireplace.lib.chat;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.MessageQueue;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_2165;
import net.minecraft.class_2561;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
@Implementation
@Singleton
public final class MessageQueueImpl implements MessageQueue {
    private final Map<class_2165, TargetMessageQueue> messageQueues = new ConcurrentHashMap<>();
    private final ExecutionManager executionManager;

    @Inject
    public MessageQueueImpl(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    private TargetMessageQueue getOrCreateQueue(class_2165 messageTarget) {
        return messageQueues.computeIfAbsent(messageTarget, TargetMessageQueue::new);
    }

    @Override
    public void queueMessages(class_2165 messageTarget, class_2561... messages) {
        getOrCreateQueue(messageTarget).queueMessages(messages);
    }

    @ThreadSafe
    private class TargetMessageQueue {
        private final Queue<class_2561> messages = new ArrayDeque<>();
        private final class_2165 messageTarget;
        private final AtomicBoolean sendingMessages = new AtomicBoolean(false);

        private TargetMessageQueue(class_2165 messageTarget) {
            this.messageTarget = messageTarget;
        }

        private synchronized void queueMessages(class_2561... messages) {
            this.messages.addAll(Arrays.asList(messages));
            if (!sendingMessages.get()) {
                MessageQueueImpl.this.executionManager.runKillable(this::sendMessages);
            }
        }

        private synchronized void sendMessages() {
            sendingMessages.set(true);
            while (!messages.isEmpty()) {
                messageTarget.method_9203(messages.remove());
            }
            sendingMessages.set(false);
        }
    }
}