package dev.the_fireplace.lib.chat.translation;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.lib.domain.translation.LocalizedClients;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ThreadSafe
@Singleton
@Implementation
public final class TranslatorManager implements TranslatorFactory
{
    private final ConcurrentMap<String, Translator> modTranslators = new ConcurrentHashMap<>();
    private final EmptyUUID emptyUUID;
    private final LocalizedClients localizedClients;
    private final I18n i18n;

    @Inject
    public TranslatorManager(
        EmptyUUID emptyUUID,
        LocalizedClients localizedClients,
        I18n i18n
    ) {
        this.emptyUUID = emptyUUID;
        this.localizedClients = localizedClients;
        this.i18n = i18n;
    }

    @Override
    public void addTranslator(String modid) {
        modTranslators.put(modid, new TranslatorImpl(modid));
    }

    @Override
    public Translator getTranslator(String modid) {
        return modTranslators.computeIfAbsent(modid, TranslatorImpl::new);
    }

    @Override
    public Collection<String> availableTranslators() {
        return modTranslators.keySet();
    }

    @ThreadSafe
    private class TranslatorImpl implements Translator
    {
        private final String modid;

        private TranslatorImpl(String modid) {
            this.modid = modid;
        }

        @Override
        public class_2561 getTextForTarget(class_2168 target, String translationKey, Object... args) {
            return getTextForTarget(getTargetId(target), translationKey, args);
        }

        @Override
        public class_2561 getTextForTarget(class_2165 target, String translationKey, Object... args) {
            return getTextForTarget(getTargetId(target), translationKey, args);
        }

        @Override
        public class_2561 getTextForTarget(UUID target, String translationKey, Object... args) {
            if (!localizedClients.isLocalized(modid, target)) {
                return getTranslatedText(translationKey, args);
            } else {
                return new class_2588(translationKey, args);
            }
        }

        @Override
        public class_2585 getTranslatedText(String translationKey, Object... translationArguments) {
            Object[] readableTranslationArguments = convertArgumentsToStrings(translationArguments);

            return new class_2585(i18n.translateToLocalFormatted(modid, translationKey, readableTranslationArguments));
        }

        private Object[] convertArgumentsToStrings(Object[] arguments) {
            Object[] convertedArgs = arguments.clone();

            for (int argumentIndex = 0; argumentIndex < arguments.length; argumentIndex++) {
                if (arguments[argumentIndex] instanceof class_2561) {
                    convertedArgs[argumentIndex] = ((class_2561) arguments[argumentIndex]).getString();
                }
            }

            return convertedArgs;
        }

        @Override
        public String getTranslatedString(String translationKey, Object... translationArguments) {
            return getTranslatedText(translationKey, translationArguments).getString();
        }

        @Override
        public String getTranslationKeyForTarget(class_2165 target, String translationKey) {
            return getTranslationKeyForTarget(getTargetId(target), translationKey);
        }

        @Override
        public String getTranslationKeyForTarget(UUID target, String translationKey) {
            if (!localizedClients.isLocalized(modid, target)) {
                return i18n.translateToLocalFormatted(modid, translationKey);
            } else {
                return translationKey;
            }
        }

        protected UUID getTargetId(class_2168 commandSource) {
            return commandSource.method_9228() instanceof class_3222
                ? commandSource.method_9228().method_5667()
                : emptyUUID.get();
        }

        protected UUID getTargetId(class_2165 commandOutput) {
            return commandOutput instanceof class_3222 ? ((class_1297) commandOutput).method_5667() : emptyUUID.get();
        }
    }
}
