package dev.the_fireplace.lib.command.helpers;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.command.injectables.ArgumentTypeFactory;
import dev.the_fireplace.lib.api.command.interfaces.OfflineSupportedPlayerArgumentType;
import dev.the_fireplace.lib.api.command.interfaces.PlayerSelector;
import dev.the_fireplace.lib.api.command.interfaces.PossiblyOfflinePlayer;
import javax.inject.Singleton;
import net.minecraft.class_2168;
import net.minecraft.class_2316;

@Implementation
@Singleton
public final class ArgumentTypeFactoryImpl implements ArgumentTypeFactory {
    public static final OfflinePlayerArgumentType.Serializer OFFLINE_PLAYER_ARGUMENT_SERIALIZER = new OfflinePlayerArgumentType.Serializer();

    @Override
    public OfflineSupportedPlayerArgumentType possiblyOfflinePlayer() {
        return new OfflinePlayerArgumentType();
    }

    @Override
    public PossiblyOfflinePlayer getPossiblyOfflinePlayer(CommandContext<class_2168> commandContext, String string) throws CommandSyntaxException {
        return commandContext.getArgument(string, PlayerSelector.class).get(commandContext.getSource());
    }

    public void registerArgumentTypes() {
        class_2316.method_10017("offline_player", OfflinePlayerArgumentType.class, OFFLINE_PLAYER_ARGUMENT_SERIALIZER);
    }
}
