package dev.the_fireplace.lib.datagen;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;

public class AdditiveDataGenerator extends class_2403 {
    private static final Logger LOGGER = LogManager.getLogger("AdditiveDataGenerator");
    private final List<class_2405> providers = Lists.newArrayList();

    public AdditiveDataGenerator(Path output, Collection<Path> collection) {
        super(output, collection);
    }

    @Override
    public void method_10315() throws IOException {
        class_2408 dataCache = new AdditiveDataCache(this.method_10313(), "cache");
        dataCache.method_16674(this.method_10313().resolve("version.json"));
        Stopwatch stopwatch = Stopwatch.createStarted();
        Stopwatch stopwatch2 = Stopwatch.createUnstarted();

        for (class_2405 dataProvider : this.providers) {
            LOGGER.info("Starting provider: {}", dataProvider.method_10321());
            stopwatch2.start();
            dataProvider.method_10319(dataCache);
            stopwatch2.stop();
            LOGGER.info("{} finished after {} ms", dataProvider.method_10321(), stopwatch2.elapsed(TimeUnit.MILLISECONDS));
            stopwatch2.reset();
        }

        LOGGER.info("All providers took: {} ms", stopwatch.elapsed(TimeUnit.MILLISECONDS));
        dataCache.method_10326();
    }

    @Override
    public void method_10314(class_2405 dataProvider) {
        this.providers.add(dataProvider);
    }
}
