package dev.the_fireplace.lib.datagen;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.datagen.injectables.DataGeneratorFactory;
import javax.inject.Singleton;
import net.minecraft.class_2403;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;

@Implementation
@Singleton
public final class DataGeneratorFactoryImpl implements DataGeneratorFactory {

    @Override
    public class_2403 createAdditive(Path outputDirectory) {
        return createAdditive(outputDirectory, Collections.emptySet());
    }

    @Override
    public class_2403 createAdditive(Path outputDirectory, Collection<Path> nbtProviderInputs) {
        return new AdditiveDataGenerator(outputDirectory, nbtProviderInputs);
    }

    @Override
    public class_2403 createDestructive(Path outputDirectory) {
        return createDestructive(outputDirectory, Collections.emptySet());
    }

    @Override
    public class_2403 createDestructive(Path outputDirectory, Collection<Path> nbtProviderInputs) {
        return new class_2403(outputDirectory, nbtProviderInputs);
    }
}
