package dev.the_fireplace.lib.inventory;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.inventory.injectables.InventorySearcher;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

@Implementation
public final class InventorySearcherImpl implements InventorySearcher
{
    @Override
    public boolean hasSlotMatching(class_1263 inventory, Predicate<class_1799> matcher) {
        for (int slot = 0; slot < inventory.method_5439(); slot++) {
            if (matcher.test(inventory.method_5438(slot))) {
                return true;
            }
        }

        return false;
    }

    @Override
    public Optional<Integer> findFirstMatchingSlot(class_1263 inventory, Predicate<class_1799> matcher) {
        for (int slot = 0; slot < inventory.method_5439(); slot++) {
            if (matcher.test(inventory.method_5438(slot))) {
                return Optional.of(slot);
            }
        }

        return Optional.empty();
    }

    @Override
    public List<Integer> findMatchingSlots(class_1263 inventory, Predicate<class_1799> matcher) {
        IntList slotList = new IntArrayList();

        for (int slot = 0; slot < inventory.method_5439(); slot++) {
            if (matcher.test(inventory.method_5438(slot))) {
                slotList.add(slot);
            }
        }

        return slotList;
    }

    @Override
    public Multimap<Integer, Integer> getMatchingSlotsByPriority(class_1263 inventory, Predicate<class_1799> matcher, ToIntFunction<class_1799> priorityMapper) {
        IntList slotList = new IntArrayList();

        for (int slot = 0; slot < inventory.method_5439(); slot++) {
            if (matcher.test(inventory.method_5438(slot))) {
                slotList.add(slot);
            }
        }

        Multimap<Integer, Integer> slotPriorityMap = LinkedHashMultimap.create();

        for (int slot : slotList) {
            slotPriorityMap.put(priorityMapper.applyAsInt(inventory.method_5438(slot)), slot);
        }

        slotPriorityMap = sortByKey(slotPriorityMap);

        return slotPriorityMap;
    }

    @Override
    public Multimap<Integer, Integer> getSlotsByPriority(class_1263 inventory, ToIntFunction<class_1799> priorityMapper) {
        Multimap<Integer, Integer> slotPriorityMap = LinkedHashMultimap.create();

        for (int slot = 0; slot < inventory.method_5439(); slot++) {
            slotPriorityMap.put(priorityMapper.applyAsInt(inventory.method_5438(slot)), slot);
        }

        slotPriorityMap = sortByKey(slotPriorityMap);

        return slotPriorityMap;
    }

    private Multimap<Integer, Integer> sortByKey(Multimap<Integer, Integer> slotPriorityMap) {
        slotPriorityMap = slotPriorityMap.entries().stream()
            .sorted((i1, i2) -> Integer.compare(i2.getKey(), i1.getKey()))
            .collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, LinkedHashMultimap::create));
        return slotPriorityMap;
    }
}
