package dev.the_fireplace.lib.io;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.injectables.DirectoryResolver;
import dev.the_fireplace.lib.entrypoints.FireplaceLib;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2874;
import net.minecraft.server.MinecraftServer;
import javax.inject.Singleton;
import java.nio.file.Path;

@Implementation
@Singleton
public final class Directories implements DirectoryResolver {

    @Override
    public Path getSavePath() {
        return getSavePath(FireplaceLib.getServer());
    }

    @Override
    public Path getSavePath(MinecraftServer server) {
        return server.method_3847(class_2874.field_13072).method_17982().method_132().toPath();
    }

    @Override
    public Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public String getLangDirectory(String modid) {
        return "/assets/" + modid + "/lang/";
    }
}
