package dev.the_fireplace.lib.network.server;

import dev.the_fireplace.lib.api.network.interfaces.ServerPacketReceiver;
import dev.the_fireplace.lib.domain.translation.LocalizedClients;
import dev.the_fireplace.lib.network.NetworkEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.HashSet;
import java.util.Set;

@Singleton
public final class ClientConnectedPacketReceiver implements ServerPacketReceiver {

    private final LocalizedClients localizedClients;

    @Inject
    public ClientConnectedPacketReceiver(LocalizedClients localizedClients) {
        this.localizedClients = localizedClients;
    }

    @Override
    public class_2960 getId() {
        return NetworkEvents.CLIENT_CONNECTED_CHANNEL_NAME;
    }

    @Override
    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Set<String> modids = new HashSet<>();
        while (buf.isReadable()) {
            modids.add(buf.method_10800(Short.MAX_VALUE));
        }
        localizedClients.addPlayer(player.method_5667(), modids);
    }
}
