/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.mobrebirth.config;

import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.mobrebirth.config.MobSettings;
import dev.the_fireplace.mobrebirth.util.MapListConverter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class DefaultMobSettings
extends MobSettings
implements Config {
    @Inject
    public DefaultMobSettings(ConfigStateManager configStateManager) {
        configStateManager.initialize((Config)this);
    }

    public String getId() {
        return "mobrebirth_defaultMobSettings";
    }

    public void afterReload(SimpleBuffer changedValues) {
        super.afterReload(changedValues);
    }

    @Override
    public void readFrom(StorageReadBuffer storageReadBuffer) {
        this.enabled = storageReadBuffer.readBool("enabled", true);
        this.rebirthChance = storageReadBuffer.readDouble("rebirthChance", 0.1);
        this.extraMobChance = storageReadBuffer.readDouble("extraMobChance", 0.01);
        this.extraMobMode = storageReadBuffer.readString("extraMobMode", "continuous");
        this.extraMobCount = storageReadBuffer.readInt("extraMobCount", 1);
        this.rebornAsEggs = storageReadBuffer.readBool("rebornAsEggs", false);
        this.rebirthFromPlayer = storageReadBuffer.readBool("rebirthFromPlayer", true);
        this.rebirthFromNonPlayer = storageReadBuffer.readBool("rebirthFromNonPlayer", true);
        this.preventSunlightDamage = storageReadBuffer.readBool("preventSunlightDamage", false);
        this.biomeList = new ArrayList();
        this.rebornMobWeights = new HashMap();
        ArrayList<String> rebornMobWeightList = new ArrayList<String>();
        for (String key : storageReadBuffer.getKeys()) {
            if (key.startsWith("biomeList-")) {
                this.biomeList.add(storageReadBuffer.readString(key, ""));
                continue;
            }
            if (!key.startsWith("rebornMobWeights-")) continue;
            rebornMobWeightList.add(storageReadBuffer.readString(key, ""));
        }
        if (this.biomeList.isEmpty() && !storageReadBuffer.readBool("biomeListIsEmpty", false)) {
            this.biomeList.add("*");
        }
        if (rebornMobWeightList.isEmpty() && !storageReadBuffer.readBool("rebornMobWeightListIsEmpty", false)) {
            this.rebornMobWeights.put("", 1);
        } else {
            this.rebornMobWeights.putAll(MapListConverter.listToMap(rebornMobWeightList));
        }
    }
}

