/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.mobrebirth.config;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.mobrebirth.domain.config.ConfigValues;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Implementation(value={"dev.the_fireplace.mobrebirth.domain.config.ConfigValues"})
public final class MRConfig
implements Config,
ConfigValues {
    private final ConfigValues defaultConfig;
    private boolean allowBossRebirth;
    private boolean allowSlimeRebirth;
    private boolean allowAnimalRebirth;
    private boolean onlyAllowVanillaMobRebirth;

    @Inject
    public MRConfig(ConfigStateManager configStateManager, @Named(value="default") ConfigValues defaultConfig) {
        this.defaultConfig = defaultConfig;
        configStateManager.initialize((Config)this);
    }

    public String getId() {
        return "mobrebirth";
    }

    public void readFrom(StorageReadBuffer buffer) {
        this.allowBossRebirth = buffer.readBool("allowBossRebirth", this.defaultConfig.getAllowBossRebirth());
        this.allowSlimeRebirth = buffer.readBool("allowSlimeRebirth", this.defaultConfig.getAllowSlimeRebirth());
        this.allowAnimalRebirth = buffer.readBool("allowAnimalRebirth", this.defaultConfig.getAllowAnimalRebirth());
        this.onlyAllowVanillaMobRebirth = buffer.readBool("onlyAllowVanillaMobRebirth", this.defaultConfig.getVanillaRebirthOnly());
    }

    public void writeTo(StorageWriteBuffer buffer) {
        buffer.writeBool("allowBossRebirth", this.allowBossRebirth);
        buffer.writeBool("allowSlimeRebirth", this.allowSlimeRebirth);
        buffer.writeBool("allowAnimalRebirth", this.allowAnimalRebirth);
        buffer.writeBool("onlyAllowVanillaMobRebirth", this.onlyAllowVanillaMobRebirth);
    }

    @Override
    public boolean getAllowBossRebirth() {
        return this.allowBossRebirth;
    }

    @Override
    public boolean getAllowSlimeRebirth() {
        return this.allowSlimeRebirth;
    }

    @Override
    public boolean getAllowAnimalRebirth() {
        return this.allowAnimalRebirth;
    }

    @Override
    public boolean getVanillaRebirthOnly() {
        return this.onlyAllowVanillaMobRebirth;
    }

    public void setAllowBossRebirth(boolean allowBossRebirth) {
        this.allowBossRebirth = allowBossRebirth;
    }

    public void setAllowSlimeRebirth(boolean allowSlimeRebirth) {
        this.allowSlimeRebirth = allowSlimeRebirth;
    }

    public void setAllowAnimalRebirth(boolean allowAnimalRebirth) {
        this.allowAnimalRebirth = allowAnimalRebirth;
    }

    public void setOnlyAllowVanillaMobRebirth(boolean onlyAllowVanillaMobRebirth) {
        this.onlyAllowVanillaMobRebirth = onlyAllowVanillaMobRebirth;
    }
}

