/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.mobrebirth.config;

import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.injectables.ConfigScreenBuilderFactory;
import dev.the_fireplace.lib.api.client.interfaces.ConfigScreenBuilder;
import dev.the_fireplace.lib.api.client.interfaces.DecimalSliderOptionBuilder;
import dev.the_fireplace.lib.api.client.interfaces.OptionBuilder;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.mobrebirth.config.DefaultMobSettings;
import dev.the_fireplace.mobrebirth.config.MRConfig;
import dev.the_fireplace.mobrebirth.config.MobSettings;
import dev.the_fireplace.mobrebirth.config.MobSettingsManager;
import dev.the_fireplace.mobrebirth.domain.config.ConfigValues;
import dev.the_fireplace.mobrebirth.util.MapListConverter;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_437;

@Singleton
@Environment(value=EnvType.CLIENT)
public final class MRConfigScreenFactory {
    private static final String TRANSLATION_BASE = "text.config.mobrebirth.";
    private static final String OPTION_TRANSLATION_BASE = "text.config.mobrebirth.option.";
    private static final String MOB_WEIGHT_MAP_ENTRY_REGEX = "([a-zA-Z_\\-0-9./]+(:[a-zA-Z_\\-0-9.]+)?)?=[0-9]+";
    private final Translator translator;
    private final ConfigStateManager configStateManager;
    private final MRConfig config;
    private final ConfigValues defaultConfigValues;
    private final ConfigScreenBuilderFactory configScreenBuilderFactory;
    private final MobSettingsManager mobSettingsManager;
    private final MobSettings defaultMobSettings;
    private ConfigScreenBuilder configScreenBuilder;

    @Inject
    public MRConfigScreenFactory(TranslatorFactory translatorFactory, ConfigStateManager configStateManager, MRConfig config, @Named(value="default") ConfigValues defaultConfigValues, ConfigScreenBuilderFactory configScreenBuilderFactory, MobSettingsManager mobSettingsManager, DefaultMobSettings defaultMobSettings) {
        this.translator = translatorFactory.getTranslator("mobrebirth");
        this.configStateManager = configStateManager;
        this.config = config;
        this.defaultConfigValues = defaultConfigValues;
        this.configScreenBuilderFactory = configScreenBuilderFactory;
        this.mobSettingsManager = mobSettingsManager;
        this.defaultMobSettings = defaultMobSettings;
    }

    public class_437 getConfigScreen(class_437 parent) {
        this.configScreenBuilder = this.configScreenBuilderFactory.create(this.translator, "text.config.mobrebirth.title", "text.config.mobrebirth.general", parent, () -> {
            this.configStateManager.save((Config)this.config);
            this.mobSettingsManager.saveAll();
        });
        this.addGeneralCategoryEntries();
        this.buildDefaultMobSettingsCategory(this.defaultMobSettings);
        for (class_2960 customMobId : this.mobSettingsManager.getMobIdsWithCustomSettings()) {
            this.buildCustomMobSettingsCategory(customMobId, this.mobSettingsManager.getSettings(customMobId));
        }
        return this.configScreenBuilder.build();
    }

    private void addGeneralCategoryEntries() {
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.allowBossRebirth", this.config.getAllowBossRebirth(), this.defaultConfigValues.getAllowBossRebirth(), this.config::setAllowBossRebirth);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.allowSlimeRebirth", this.config.getAllowSlimeRebirth(), this.defaultConfigValues.getAllowSlimeRebirth(), this.config::setAllowSlimeRebirth);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.allowAnimalRebirth", this.config.getAllowAnimalRebirth(), this.defaultConfigValues.getAllowAnimalRebirth(), this.config::setAllowAnimalRebirth);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.onlyAllowVanillaMobRebirth", this.config.getVanillaRebirthOnly(), this.defaultConfigValues.getVanillaRebirthOnly(), this.config::setOnlyAllowVanillaMobRebirth);
        this.createAddCustomMobDropdown();
    }

    private void createAddCustomMobDropdown() {
        this.configScreenBuilder.addStringDropdown("text.config.mobrebirth.option.addCustomMob", "", "", (Iterable)this.mobSettingsManager.getMobIdsWithoutCustomSettings().stream().map(class_2960::toString).sorted().collect(Collectors.toList()), newValue -> {
            if (!newValue.isEmpty()) {
                this.mobSettingsManager.addCustom(new class_2960(newValue), this.defaultMobSettings.clone());
            }
        }).setDescriptionRowCount((byte)2).setErrorSupplier(value -> this.mobSettingsManager.isCustom(new class_2960(value)) ? Optional.of(this.translator.getTranslatedText("text.config.mobrebirth.option.addCustomMob.err", new Object[0])) : Optional.empty());
    }

    private void buildDefaultMobSettingsCategory(MobSettings mobSettings) {
        this.configScreenBuilder.startCategory("text.config.mobrebirth.defaultSettings", new Object[0]);
        this.addCommonMobSettingsCategoryOptions(mobSettings);
    }

    private void buildCustomMobSettingsCategory(class_2960 id, MobSettings mobSettings) {
        this.configScreenBuilder.startCategory("text.config.mobrebirth.mobSettings", new Object[]{id.toString()});
        this.addCommonMobSettingsCategoryOptions(mobSettings);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.deleteCustomMob", false, false, newValue -> {
            if (newValue.booleanValue()) {
                this.mobSettingsManager.deleteCustom(id);
            }
        }).setDescriptionRowCount((byte)2);
    }

    private void addCommonMobSettingsCategoryOptions(MobSettings mobSettings) {
        OptionBuilder enabled = this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.enabled", mobSettings.isEnabled(), this.defaultMobSettings.isEnabled(), mobSettings::setEnabled).setDescriptionRowCount((byte)2);
        DecimalSliderOptionBuilder rebirthChance = this.configScreenBuilder.addDoubleSlider("text.config.mobrebirth.option.rebirthChance", mobSettings.getRebirthChance(), this.defaultMobSettings.getRebirthChance(), mobSettings::setRebirthChance, 0.0, 100.0);
        rebirthChance.enablePercentMode();
        rebirthChance.addDependency(enabled);
        DecimalSliderOptionBuilder multiMobChance = this.configScreenBuilder.addDoubleSlider("text.config.mobrebirth.option.multiMobChance", mobSettings.getExtraMobChance(), this.defaultMobSettings.getExtraMobChance(), mobSettings::setExtraMobChance, 0.0, 100.0);
        multiMobChance.enablePercentMode();
        multiMobChance.addDependency((OptionBuilder)rebirthChance, value -> value > 0.0);
        this.configScreenBuilder.addStringDropdown("text.config.mobrebirth.option.multiMobMode", mobSettings.getExtraMobMode(), this.defaultMobSettings.getExtraMobMode(), Arrays.asList("continuous", "per-mob", "all"), mobSettings::setExtraMobMode).setDescriptionRowCount((byte)5).addDependency((OptionBuilder)multiMobChance, value -> value > 0.0);
        this.configScreenBuilder.addIntField("text.config.mobrebirth.option.multiMobCount", mobSettings.getExtraMobCount(), this.defaultMobSettings.getExtraMobCount(), mobSettings::setExtraMobCount).setMinimum((Object)0).setDescriptionRowCount((byte)2).addDependency((OptionBuilder)multiMobChance, value -> value > 0.0);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.rebornAsEggs", mobSettings.isRebornAsEggs(), this.defaultMobSettings.isRebornAsEggs(), mobSettings::setRebornAsEggs).addDependency((OptionBuilder)rebirthChance, value -> value > 0.0);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.rebirthFromPlayer", mobSettings.isRebirthFromPlayer(), this.defaultMobSettings.isRebirthFromPlayer(), mobSettings::setRebirthFromPlayer).addDependency((OptionBuilder)rebirthChance, value -> value > 0.0);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.rebirthFromNonPlayer", mobSettings.isRebirthFromNonPlayer(), this.defaultMobSettings.isRebirthFromNonPlayer(), mobSettings::setRebirthFromNonPlayer).addDependency((OptionBuilder)rebirthChance, value -> value > 0.0);
        this.configScreenBuilder.addBoolToggle("text.config.mobrebirth.option.preventSunlightDamage", mobSettings.isPreventSunlightDamage(), this.defaultMobSettings.isPreventSunlightDamage(), mobSettings::setPreventSunlightDamage).setDescriptionRowCount((byte)2).addDependency(enabled);
        this.configScreenBuilder.addStringListField("text.config.mobrebirth.option.biomeList", mobSettings.getBiomeList(), this.defaultMobSettings.getBiomeList(), mobSettings::setBiomeList).setDescriptionRowCount((byte)2).addDependency((OptionBuilder)rebirthChance, value -> value > 0.0);
        this.configScreenBuilder.addStringListField("text.config.mobrebirth.option.rebornMobWeights", MapListConverter.mapToList(mobSettings.getRebornMobWeights()), MapListConverter.mapToList(this.defaultMobSettings.getRebornMobWeights()), newValue -> mobSettings.setRebornMobWeights(MapListConverter.listToMap(newValue))).setDescriptionRowCount((byte)2).setErrorSupplier(strList -> {
            for (String str : strList) {
                if (str.matches(MOB_WEIGHT_MAP_ENTRY_REGEX)) continue;
                return Optional.of(this.translator.getTranslatedText("text.config.mobrebirth.option.rebornMobWeights.err", new Object[]{str}));
            }
            return Optional.empty();
        }).addDependency((OptionBuilder)rebirthChance, value -> value > 0.0);
    }
}

