/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.mobrebirth.config;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.mobrebirth.config.DefaultMobSettings;
import dev.the_fireplace.mobrebirth.util.MapListConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobSettings
implements HierarchicalConfig {
    protected boolean enabled;
    protected double rebirthChance;
    protected double extraMobChance;
    protected String extraMobMode;
    protected int extraMobCount;
    protected boolean rebornAsEggs;
    protected boolean rebirthFromPlayer;
    protected boolean rebirthFromNonPlayer;
    protected boolean preventSunlightDamage;
    protected List<String> biomeList;
    protected Map<String, Integer> rebornMobWeights;

    public MobSettings clone() {
        MobSettings clone = new MobSettings();
        clone.enabled = this.enabled;
        clone.rebirthChance = this.rebirthChance;
        clone.extraMobChance = this.extraMobChance;
        clone.extraMobMode = this.extraMobMode;
        clone.extraMobCount = this.extraMobCount;
        clone.rebornAsEggs = this.rebornAsEggs;
        clone.rebirthFromPlayer = this.rebirthFromPlayer;
        clone.rebirthFromNonPlayer = this.rebirthFromNonPlayer;
        clone.preventSunlightDamage = this.preventSunlightDamage;
        clone.biomeList = this.biomeList;
        clone.rebornMobWeights = this.rebornMobWeights;
        return clone;
    }

    public void readFrom(StorageReadBuffer storageReadBuffer) {
        MobSettings defaultSettings = (MobSettings)DIContainer.get().getInstance(DefaultMobSettings.class);
        this.enabled = storageReadBuffer.readBool("enabled", defaultSettings.isEnabled());
        this.rebirthChance = storageReadBuffer.readDouble("rebirthChance", defaultSettings.getRebirthChance());
        this.extraMobChance = storageReadBuffer.readDouble("extraMobChance", defaultSettings.getExtraMobChance());
        this.extraMobMode = storageReadBuffer.readString("extraMobMode", defaultSettings.getExtraMobMode());
        this.extraMobCount = storageReadBuffer.readInt("extraMobCount", defaultSettings.getExtraMobCount());
        this.rebornAsEggs = storageReadBuffer.readBool("rebornAsEggs", defaultSettings.isRebornAsEggs());
        this.rebirthFromPlayer = storageReadBuffer.readBool("rebirthFromPlayer", defaultSettings.isRebirthFromPlayer());
        this.rebirthFromNonPlayer = storageReadBuffer.readBool("rebirthFromNonPlayer", defaultSettings.isRebirthFromNonPlayer());
        this.preventSunlightDamage = storageReadBuffer.readBool("preventSunlightDamage", defaultSettings.isPreventSunlightDamage());
        this.biomeList = new ArrayList<String>();
        this.rebornMobWeights = new HashMap<String, Integer>();
        ArrayList<String> rebornMobWeightList = new ArrayList<String>();
        for (String key : storageReadBuffer.getKeys()) {
            if (key.startsWith("biomeList-")) {
                this.biomeList.add(storageReadBuffer.readString(key, ""));
                continue;
            }
            if (!key.startsWith("rebornMobWeights-")) continue;
            rebornMobWeightList.add(storageReadBuffer.readString(key, ""));
        }
        if (this.biomeList.isEmpty() && !storageReadBuffer.readBool("biomeListIsEmpty", false)) {
            this.biomeList.addAll(defaultSettings.getBiomeList());
        }
        if (rebornMobWeightList.isEmpty() && !storageReadBuffer.readBool("rebornMobWeightListIsEmpty", false)) {
            this.rebornMobWeights.putAll(defaultSettings.getRebornMobWeights());
        } else {
            this.rebornMobWeights.putAll(MapListConverter.listToMap(rebornMobWeightList));
        }
    }

    public void writeTo(StorageWriteBuffer storageWriteBuffer) {
        storageWriteBuffer.writeBool("enabled", this.enabled);
        storageWriteBuffer.writeDouble("rebirthChance", this.rebirthChance);
        storageWriteBuffer.writeDouble("extraMobChance", this.extraMobChance);
        storageWriteBuffer.writeString("extraMobMode", this.extraMobMode);
        storageWriteBuffer.writeInt("extraMobCount", this.extraMobCount);
        storageWriteBuffer.writeBool("rebornAsEggs", this.rebornAsEggs);
        storageWriteBuffer.writeBool("rebirthFromPlayer", this.rebirthFromPlayer);
        storageWriteBuffer.writeBool("rebirthFromNonPlayer", this.rebirthFromNonPlayer);
        storageWriteBuffer.writeBool("preventSunlightDamage", this.preventSunlightDamage);
        for (String biome : this.biomeList) {
            storageWriteBuffer.writeString("biomeList-" + biome, biome);
        }
        if (this.biomeList.isEmpty()) {
            storageWriteBuffer.writeBool("biomeListIsEmpty", true);
        }
        List<String> rebornMobWeightList = MapListConverter.mapToList(this.rebornMobWeights);
        for (String weight : rebornMobWeightList) {
            storageWriteBuffer.writeString("rebornMobWeights-" + weight, weight);
        }
        if (rebornMobWeightList.isEmpty()) {
            storageWriteBuffer.writeBool("rebornMobWeightListIsEmpty", true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getRebirthChance() {
        return this.rebirthChance;
    }

    public void setRebirthChance(double rebirthChance) {
        this.rebirthChance = rebirthChance;
    }

    public double getExtraMobChance() {
        return this.extraMobChance;
    }

    public void setExtraMobChance(double extraMobChance) {
        this.extraMobChance = extraMobChance;
    }

    public String getExtraMobMode() {
        return this.extraMobMode;
    }

    public void setExtraMobMode(String extraMobMode) {
        this.extraMobMode = extraMobMode;
    }

    public int getExtraMobCount() {
        return this.extraMobCount;
    }

    public void setExtraMobCount(int extraMobCount) {
        this.extraMobCount = extraMobCount;
    }

    public boolean isRebornAsEggs() {
        return this.rebornAsEggs;
    }

    public void setRebornAsEggs(boolean rebornAsEggs) {
        this.rebornAsEggs = rebornAsEggs;
    }

    public boolean isRebirthFromPlayer() {
        return this.rebirthFromPlayer;
    }

    public void setRebirthFromPlayer(boolean rebirthFromPlayer) {
        this.rebirthFromPlayer = rebirthFromPlayer;
    }

    public boolean isRebirthFromNonPlayer() {
        return this.rebirthFromNonPlayer;
    }

    public void setRebirthFromNonPlayer(boolean rebirthFromNonPlayer) {
        this.rebirthFromNonPlayer = rebirthFromNonPlayer;
    }

    public boolean isPreventSunlightDamage() {
        return this.preventSunlightDamage;
    }

    public void setPreventSunlightDamage(boolean preventSunlightDamage) {
        this.preventSunlightDamage = preventSunlightDamage;
    }

    public List<String> getBiomeList() {
        return this.biomeList;
    }

    public void setBiomeList(List<String> biomeList) {
        this.biomeList = biomeList;
    }

    public Map<String, Integer> getRebornMobWeights() {
        return this.rebornMobWeights;
    }

    public void setRebornMobWeights(Map<String, Integer> rebornMobWeights) {
        this.rebornMobWeights = rebornMobWeights;
    }
}

