/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.client.gui.squad.SelectorScreen;
import dev.the_fireplace.overlord.domain.client.ScreenOpener;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.entity.OrderableEntity;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.item.OrdersWandItem;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.client.builder.GetOrdersBufferBuilder;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Implementation
@Environment(value=EnvType.CLIENT)
public final class ScreenOpenerImpl
implements ScreenOpener {
    private final Squads squads;
    private final EmptyUUID emptyUUID;
    private final class_310 client;

    @Inject
    public ScreenOpenerImpl(@Named(value="client") Squads squads, EmptyUUID emptyUUID) {
        this.squads = squads;
        this.emptyUUID = emptyUUID;
        this.client = class_310.method_1551();
    }

    @Override
    public void openOrdersGUI(OrderableEntity entity) {
        ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.GET_ORDERS, (class_2540)GetOrdersBufferBuilder.build(entity.getEntityIdNumber()));
    }

    @Override
    public void openSquadSelectorGUI(@Nullable ArmyEntity entity) {
        SelectorScreen selectorScreen;
        if (entity != null) {
            selectorScreen = new SelectorScreen((class_2561)new class_2588("gui.overlord.squad_manager.name"), this.client.field_1755, this.squads.getSquadsWithOwner(entity.method_6139()), entity.getEntityIdNumber(), entity.getSquad());
        } else {
            Objects.requireNonNull(this.client.field_1724);
            class_1799 activeWand = OrdersWandItem.getActiveWand((class_1657)this.client.field_1724);
            UUID currentSquad = activeWand.method_7985() && activeWand.method_7969().method_10545("squad") ? activeWand.method_7969().method_25926("squad") : this.emptyUUID.get();
            selectorScreen = new SelectorScreen((class_2561)new class_2588("gui.overlord.squad_manager.name"), this.client.field_1755, this.squads.getSquadsWithOwner(this.client.field_1724.method_5667()), null, currentSquad);
        }
        this.client.method_1507((class_437)selectorScreen);
    }
}

