/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.config;

import dev.the_fireplace.lib.api.client.interfaces.CustomButtonScreen;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.PositionSetting;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class PositionSelectorGui
extends class_437
implements CustomButtonScreen<String> {
    public static final Predicate<String> IS_NUMBER = testStr -> {
        try {
            Integer.parseInt(testStr);
            return true;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    };
    private final Promise<Optional<String>> resultPromise = new DefaultPromise((EventExecutor)new DefaultEventExecutor());
    private final class_437 parent;
    private final PositionSetting previousSelection;
    private final class_2338 currentPosition;
    private class_4185 confirmButton;
    private class_342 xWidget;
    private class_342 yWidget;
    private class_342 zWidget;

    public PositionSelectorGui(class_2561 title, class_437 parent, String currentValue, @Nullable class_2338 currentPosition) {
        super(title);
        this.parent = parent;
        this.previousSelection = PositionSetting.fromString(currentValue);
        this.currentPosition = currentPosition;
    }

    public Promise<Optional<String>> getNewValuePromise() {
        return this.resultPromise;
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            throw new IllegalStateException("Cannot initialize with null client!");
        }
        this.xWidget = new class_342(this.field_22787.field_1772, this.field_22789 / 2 - 75 - 2, this.field_22790 / 2, 50, 20, class_2561.method_30163((String)"X"));
        this.method_37063((class_364)this.xWidget);
        this.yWidget = new class_342(this.field_22787.field_1772, this.field_22789 / 2 - 25, this.field_22790 / 2, 50, 20, class_2561.method_30163((String)"Y"));
        this.method_37063((class_364)this.yWidget);
        this.zWidget = new class_342(this.field_22787.field_1772, this.field_22789 / 2 + 25 + 2, this.field_22790 / 2, 50, 20, class_2561.method_30163((String)"Z"));
        this.method_37063((class_364)this.zWidget);
        class_4185 currentPositionButton = new class_4185(this.field_22789 / 2 - 100, this.field_22790 / 2 - 30, 200, 20, (class_2561)new class_2588("gui.overlord.select_position.use_current"), button -> this.setCoordinates(this.currentPosition.method_10263(), this.currentPosition.method_10264(), this.currentPosition.method_10260()));
        this.method_37063((class_364)currentPositionButton);
        this.confirmButton = new class_4185(this.field_22789 / 2 - 202, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("gui.overlord.confirm_exit"), button -> {
            PositionSetting newPosition = new PositionSetting(Integer.parseInt(this.xWidget.method_1882()), Integer.parseInt(this.yWidget.method_1882()), Integer.parseInt(this.zWidget.method_1882()));
            this.resultPromise.setSuccess(Optional.of(newPosition.toString()));
            this.closeScreen();
        });
        this.method_37063((class_364)this.confirmButton);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("gui.cancel"), button -> {
            this.resultPromise.setSuccess(Optional.empty());
            this.closeScreen();
        }));
        currentPositionButton.field_22764 = this.currentPosition != null;
        this.setCoordinates(this.previousSelection.getX(), this.previousSelection.getY(), this.previousSelection.getZ());
    }

    private void setCoordinates(int x, int y, int z) {
        this.xWidget.method_1852(String.valueOf(x));
        this.yWidget.method_1852(String.valueOf(y));
        this.zWidget.method_1852(String.valueOf(z));
    }

    private void closeScreen() {
        this.method_25419();
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        this.method_25420(matrixStack);
        if (this.confirmButton.field_22763 && this.hasInvalidCoordinate()) {
            this.confirmButton.field_22763 = false;
        } else if (!this.confirmButton.field_22763 && !this.hasInvalidCoordinate()) {
            this.confirmButton.field_22763 = true;
        }
        super.method_25394(matrixStack, mouseX, mouseY, delta);
    }

    private boolean hasInvalidCoordinate() {
        return !IS_NUMBER.test(this.xWidget.method_1882()) || !IS_NUMBER.test(this.yWidget.method_1882()) || !IS_NUMBER.test(this.zWidget.method_1882());
    }
}

